package ibase.e12ria.client;
import ibase.e12ria.client.E12RequestBuilder.RequestDataKeys;
import ibase.e12ria.client.resources.Resources;
import ibase.e12ria.e12widgets.client.E12TagActionLinks;
import ibase.e12ria.e12widgets.client.E12TreeItem;
import ibase.e12ria.e12widgets.client.EntryWrapper;
import ibase.e12ria.e12widgets.shared.E12Storage;
import ibase.e12ria.e12widgets.client.E12PopupContainer;
import ibase.e12ria.shared.ScreenDTO;
import ibase.e12ria.shared.TabDTO;
import ibase.e12ria.social.client.plugins.messagenotificationplugin.NotificationPanel;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.TreeSet;

import com.google.gwt.core.client.Callback;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.RunAsyncCallback;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.LinkElement;
import com.google.gwt.dom.client.Style.Display;
import com.google.gwt.dom.client.Style.Overflow;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.ErrorEvent;
import com.google.gwt.event.dom.client.ErrorHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.TabBar;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;

/**
 * The Main entry point class for the BaseE12 application.
 */
 //Added By Prajyot Rumde On 11-08-2011 [RnD]
public class BaseE12 extends ResizeComposite {

	interface Binder extends UiBinder<DockLayoutPanel, BaseE12> { }

	private static List<E12Communicator> communicators = new ArrayList <E12Communicator>();
	static public HashMap<String, SelectionHandler<TreeItem>> treeSelectionHandlers = new HashMap<String, SelectionHandler<TreeItem>>();
	private static final Binder binder = GWT.create(Binder.class);
	public final I18NConstants constants = GWT.create(I18NConstants.class);
	//Addded by Amol S on 27-07-17
	E12Groups e12Groups = new E12Groups();


	//Added by yogesh on 22-oct-11 [SY1GSUN001 | set formal arg.value in search option].End
	static public  ArrayList tabArrayList = new ArrayList();
	static public  LinkedHashMap tabHashMap = new LinkedHashMap();

	static Map<String, String> tabsMap = new LinkedHashMap<String, String>();
	protected ArrayList<String > favouriteNameLst = new ArrayList<String>();

	public boolean isWidgetPresent = false;
	public String instanceIdStr;


	//Test git
	public static String callerInterface = "";
	private final String errMsg = constants.setErrMsgAlt();
	private final String moreThan12 = constants.setMoreThan12Alt();
	private final String invalidObj = constants.setInvalidObjAlt();

	@UiField static E12HeaderPanel e12HeaderPanel;
	//change by shrutika on 28-03-19 for Implement on shift + tab functionality to switch open tab.
	//@UiField static E12MenuPanel e12MenuPanel;
	@UiField public static E12MenuPanel e12MenuPanel;
	// Commented and Add by Dnyaneshwar Chavan on 2-Nov-15[ Implement Super Dev Mode ] Start
	//@UiField static SplitLayoutPanel e12SplitLytPanel;
	//Commented and Added by Pankaj R on 06-Jan-17 to change the width of Splitter.[START]
	//@UiField static E12SplitLayoutPanel e12SplitLytPanel;
	@UiField(provided=true) static E12SplitLayoutPanel e12SplitLytPanel = new E12SplitLayoutPanel();
	//Commented and Added by Pankaj R on 06-Jan-17 to change the width of Splitter.[END]
	// Commented and Add by Dnyaneshwar Chavan on 2-Nov-15[ Implement Super Dev Mode ] End
	@UiField static DockLayoutPanel e12Docklayout;
  	@UiField static E12TransBrow e12TransBrow;
	//Changed By Mahesh Patidar on 31/DEC/12 for Notification Implementation
  	//Added by Nilesh Soor on 31/12/2014 [ OnSelect Menu expand-collapse ]
  	private Element lastSelectedExplItem = null;
  	static String wrkflwCurrentView = "ListView";
  	private String isDcrOpen = "false";
  	public static CustomTabLayoutWidget custTabLayoutWidget;  	//Added by Dnyaneshwar Chavan on 31-Nov-15 [ Dashboard widgets not resize ] Start

  	//Added by Amol S
  	private boolean isMyCircle = false;

	public HashMap<String, String> wizardParamMap ;

  	static
	{
		E12Constants.userID = DOM.getElementById( "userID" ).getInnerText();
		E12Constants.conApplNm = DOM.getElementById( "APPL_NAME" ).getInnerText();
		E12Constants.userTheme = DOM.getElementById( "userTheme" ).getInnerText();
		//Added by Vishal P on 11/08/16 [for //Added by Vishal Pathare on 12-AUG-2016 for[getting <ux_interface>] value for theme interface]]
		E12Constants.uxInterface = DOM.getElementById( "uxInterface" ).getInnerText();
	}
  	//Ended By Mahesh Patidar
	/**
	 * Main method for the application.
	 * This method is entry point of application it decide which application is to be load.
	 */
	public BaseE12() {
	  	//Added By Ajinkya Gopalkar on 13-OCT-15[for keyboard shortcut]
		E12KeyBoardShortcut.removePreviewHandler();
		E12KeyBoardShortcut.setKeyBoardShortcut();
		E12CommonUtils.printOnConsole(".........3.1");
		exportMethods(this); // Added by Dnyaneshwar chavan on 26-Apr-14 [ Hide the E12Intro popup panel] Start

		callerInterface = DOM.getElementById( "callerInterface" ).getInnerText();

		Resources.INSTANCE.elegant_icons().ensureInjected();
		Resources.INSTANCE.roboto_regular().ensureInjected();
		// Inject global styles.
		GWT.<Resources.ThemeResources>create(Resources.ThemeResources.class).defaultCSS().ensureInjected();
		//Added by Shrutika on 01-02-18 for display site code below the user name when login.
		setE12Constants();
		// Create the UI defined in ITMExplorer.ui.xml.
		DockLayoutPanel outer = binder.createAndBindUi( this );

		E12CommonUtils.printOnConsole(".........3.2");
		//Changed By Mahesh Patidar on 01/JUL/13[to set E12Constants Values]
		//Commented by Shrutika on 01-02-18 for display site code below the user name when login.
		//setE12Constants();
		setEnterpriseLogo(); //Added by Pankaj R on 14-11-17 for enterprise logo
		E12CommonUtils.printOnConsole(".........3.3");
		updateStyles(); //Bugfixing
		E12CommonUtils.printOnConsole(".........3.4");
		E12CommonUtils.applyUserTheme();
		E12CommonUtils.printOnConsole(".........3.5");
		//Added by sunny soni for passing enterprise name to inject css file as per enterprisName on 25-Nov-21[Start]
		String enterpriseName = E12CommonUtils.checkNull(E12Constants.enterprise);
		E12CommonUtils.printOnConsole("enterpriseName::["+enterpriseName+"]");
		if (enterpriseName.length() > 0) {
			injectCssFile(enterpriseName);
		}
		//Added by sunny soni for passing enterprise name to inject css file as per enterprisName on 25-Nov-21[End]

		//Changed by Reema on 23-Jun-15 [for browser Compatible]
		if( ( Window.Navigator.getUserAgent().toLowerCase().indexOf("firefox") > -1 ) && E12Global.isGalaxy())
		{
			E12CommonUtils.printOnConsole("firefox browser");
			GWT.<Resources.ThemeResources>create(Resources.ThemeResources.class).firefoxCSS().ensureInjected();
		}
		//Changed by Savita Yadav on 07-08-2015 [for IE Browser]
		else if( ( Window.Navigator.getUserAgent().toLowerCase().contains("msie") || Window.Navigator.getUserAgent().toLowerCase().contains("trident") ) && E12Global.isGalaxy())
		{
			E12CommonUtils.printOnConsole("MSIE browser");
			GWT.<Resources.ThemeResources>create(Resources.ThemeResources.class).galaxy_IECSS().ensureInjected();
		}
		//Changed by Reema on 23-Jun-15 [for browser Compatible]-End

		DOM.removeChild( RootPanel.getBodyElement(), DOM.getElementById( "loading" ) );

		// Get rid of scrollbars, and clear out the window's built-in margin,
		// because we want to take advantage of the entire client area.
		Window.enableScrolling( false );
		Window.setMargin( "0px" );

		//Commented to Remove Welcome LinkMssages
		//e12HeaderPanel.welcomeMsgLink.setText( constants.setWelcomeLbl() + " " + E12Constants.welcomeMsg );
		//Changed By Prajyot P. Rumde on 11-08-2011 [RnD] Starts
		loadProfileFromServlet(E12Constants.userID);
		E12CommonUtils.printOnConsole(".........3.6");
		//Creating Tree Selection Handlers
		treeSelectionHandlers.put("EXPLORER", new SelectionHandler<TreeItem>() {
			//Added by Nilesh Soor on 30/12/2014 [ Explorer Tree: UI changes  ] START
			Long clickTimeSpan = null;
			//Added by Nilesh Soor on 30/12/2014 [ Explorer Tree: UI changes  ] END
			@Override
			public void onSelection( SelectionEvent<TreeItem> event )
			{
				E12Global.getInstance().setSocialPanel(false);
				try
				{
					// added by Mahesh Saggam on 17-DEC-19 [when clicking on downward key system opens any transaction randomly.] Start
					Scheduler.get().scheduleDeferred(new ScheduledCommand() {
						@Override
						public void execute() {
							if(DOM.getElementById("searchBox") != null)
								DOM.getElementById("searchBox").focus();
						}
					});
					// added by Mahesh Saggam on 17-DEC-19 [when clicking on down word key system opens any transaction randomly.] End
					//Added by Reema on 16-mar-15 [open first menu from tree default]
					if(e12MenuPanel.e12TransMenu.count == 0)
					{
						lastSelectedExplItem = e12MenuPanel.e12TransMenu.lastSelectedExplItem;
						e12MenuPanel.e12TransMenu.count++;
					}
					//Added by Reema on 16-mar-15 [open first menu from tree default]-End
					Date date= new Date();
					Long clickTime = date.getTime();
					if( clickTimeSpan == null || clickTimeSpan < clickTime || clickTimeSpan.equals( clickTime ) )
					{
						clickTimeSpan = clickTime + 500;

						final E12TreeItem item = (E12TreeItem) event.getSelectedItem();
						//Changes made by Pratheek on 08-04-19[on use of shift tab button the style was getting removed on selected menu]-Start
						if(( item != null ) && ( item.getChildCount() == 0 ) && !item.getElement().getId().equalsIgnoreCase("more_button"))
						{
							//Changes made by Pratheek on 23-04-19[ to get the select menu for adding and removing the style of favourite button]-Start
							E12TransInfoObj e12TransInfoObj = ( E12TransInfoObj ) ( item.getUserObject() );
							//Changes made by Pratheek on 23-04-19[ to get the select menu for adding and removing the style of favourite button]-End
							if( lastSelectedExplItem != null )
							{
								//lastSelectedExplItem.removeClassName("menuSelected");
								lastSelectedExplItem.removeClassName("menuSelected-"+E12ApplicationMenuBar.getApplColor() );
								//Changes made by Pratheek on 23-04-19[ to get the select menu for adding and removing the style of favourite button]-Start
								if( DOM.getElementById("FavMenuMoreButton"+e12TransInfoObj.getId()) != null  )
								{
									DOM.getElementById("FavMenuMoreButton"+e12TransInfoObj.getId()).removeClassName("selectedMoreButton");
								}
								//Changes made by Pratheek on 23-04-19[ to get the select menu for adding and removing the style of favourite button]-End
							}
							com.google.gwt.dom.client.NodeList<com.google.gwt.dom.client.Node> nodeList = item.getElement().getChildNodes();
							if( nodeList !=null && nodeList.getLength() > 0 )
							{
								Element element = nodeList.getItem(0).cast();
								//element.addClassName("menuSelected");
								if( element != null )
								{
									element.addClassName("menuSelected-"+E12ApplicationMenuBar.getApplColor() );
									lastSelectedExplItem = element;
								}
							}
							//Changes made by Pratheek on 23-04-19[ to get the select menu for adding and removing the style of favourite button]-Start
							if( DOM.getElementById("FavMenuMoreButton"+e12TransInfoObj.getId()) != null)
							{
								DOM.getElementById("FavMenuMoreButton"+e12TransInfoObj.getId()).addClassName("selectedMoreButton");
							}
							//Changes made by Pratheek on 23-04-19[ to get the select menu for adding and removing the style of favourite button]-End
							// Added and Commented by Dnyaneshwar chavan on 26-Apr-14 [ Hide the E12Intro popup panel] Start
							openTransaction(e12TransInfoObj);
						}
						//Added by Nilesh Soor on 30/12/2014 [ Explorer Tree: UI changes  ] START
						//Changes made by Pratheek on 08-04-19[on use of shift tab button the style was getting removed on selected menu]-Start
						else if( item != null && !item.getElement().getId().equalsIgnoreCase("more_button"))
						{
							if( lastSelectedExplItem != null )
							{
								//lastSelectedExplItem.removeClassName("menuSelected");
								lastSelectedExplItem.removeClassName("menuSelected-"+E12ApplicationMenuBar.getApplColor() );
							}

							com.google.gwt.dom.client.NodeList<com.google.gwt.dom.client.Node> nodeList = item.getElement().getChildNodes();
							if( nodeList!=null && nodeList.getLength() > 0 )
							{
								Element element = nodeList.getItem(0).cast();
								if( element != null )
								{
									com.google.gwt.dom.client.Node chNode = element.getChild(0);
									if( chNode != null && chNode.getFirstChild() != null && chNode.getFirstChild().getChildCount() >= 2 )
									{
										com.google.gwt.dom.client.Node tNode = chNode.getFirstChild().getChild(1).getFirstChild();
										Element treeDiv = tNode.cast();
										//treeDiv.addClassName("menuSelected");
										treeDiv.addClassName("menuSelected-"+E12ApplicationMenuBar.getApplColor());
										lastSelectedExplItem = treeDiv;
										if(item.getState())
										{
											treeDiv.removeClassName("upArrow");
										}
										else
										{
											treeDiv.addClassName("upArrow");
										}
									}
								}
							}
							item.setState(!item.getState());
						}
						else
						{
							E12CommonUtils.printOnConsole("When select the Explorer tree  item == null item[" +  item + "] event [" + event + "]");
						}
						//Added by Nilesh Soor on 30/12/2014 [ Explorer Tree: UI changes  ] END
					}
				}
				catch (Exception e)
				{
					E12CommonUtils.printOnConsole( "Exception :: When select the Explorer tree ["+e.toString()+"]");
					e.printStackTrace();
				}
			}
		});

		treeSelectionHandlers.put("WORKFLOW", new SelectionHandler<TreeItem>() {
			//Added by Nilesh Soor on 30/12/2014 [ Workflow Tree: UI changes  ] START
			Long clickTimeSpan = null;
			//Added by Nilesh Soor on 30/12/2014 [ Workflow Tree: UI changes  ] END
			@Override
			public void onSelection( SelectionEvent<TreeItem> event )
			{
				E12Global.getInstance().setSocialPanel(false);
				try
				{
					final E12TreeItem item = (E12TreeItem) event.getSelectedItem();
					E12CommonUtils.printOnConsole("selectedItem["+ (item!=null? item.getTreeItemID():item ) +"]");
					//Added By Pankaj T. on 28-04-2020 resolved issue in workflow approve & rejected tree when for context2 against multiple feed & left side panel display only single feed - start
					E12CommonUtils.printOnConsole("Selected item:["+item+"]");
					String selectedTreeIndex = item.getElement().getFirstChildElement().getAttribute("aria-posinset");
					E12CommonUtils.printOnConsole("Selected item selectedTreeIndex:["+selectedTreeIndex+"]");
					//Added By Pankaj T. on 28-04-2020 resolved issue in workflow approve & rejected tree when for context2 against multiple feed & left side panel display only single feed - start
					//Changed by Nilesh Soor on 06/01/2015 [ Workflow Tree: UI changes ]
					//openWorkflw(item);
					Date date= new Date();
					Long clickTime = date.getTime();
					if( clickTimeSpan == null || clickTimeSpan < new Date().getTime() || clickTimeSpan.equals( new Date().getTime() ) )
					{
						clickTimeSpan = clickTime + 500;
						if(( item != null ) && ( item.getChildCount() == 0 ) )
						{
//							E12MenuPanel.selectedWrkflwItm = item;
							if( lastSelectedExplItem != null )
							{
								lastSelectedExplItem.removeClassName("menuSelected-wrk");
							}
							com.google.gwt.dom.client.NodeList<com.google.gwt.dom.client.Node> nodeList = item.getElement().getChildNodes();
							if( nodeList!=null && nodeList.getLength() > 0 )
							{
								Element element = nodeList.getItem(0).cast();
								if( element != null )
								{
									element.addClassName("menuSelected-wrk");
									lastSelectedExplItem = element;
								}
							}
							//Changed By Pankaj T. on 28-04-2020 resolved issue in workflow approve & rejected tree when for context2 against multiple feed & left side panel display only single feed
							e12MenuPanel.e12Workflow.openWorkflw(item, selectedTreeIndex);
						}
						else if( item != null )
						{
//							E12MenuPanel.selectedWrkflwItm = item;
							if( lastSelectedExplItem != null )
							{
								lastSelectedExplItem.removeClassName("menuSelected-wrk");
							}

							com.google.gwt.dom.client.NodeList<com.google.gwt.dom.client.Node> nodeList = item.getElement().getChildNodes();
							if( nodeList!=null && nodeList.getLength() > 0 )
							{
								Element element = nodeList.getItem(0).cast();
								if( element != null )
								{
									com.google.gwt.dom.client.Node chNode = element.getChild(0);
									if( chNode != null && chNode.getFirstChild() != null && chNode.getFirstChild().getChildCount() >= 2 )
									{
										com.google.gwt.dom.client.Node tNode = chNode.getFirstChild().getChild(1).getFirstChild();
										Element treeDiv = tNode.cast();
										treeDiv.addClassName("menuSelected-wrk");
										lastSelectedExplItem = treeDiv;
										if(item.getState())
										{
											treeDiv.removeClassName("upArrow");
										}
										else
										{
											treeDiv.addClassName("upArrow");
										}
									}
								}
							}
							item.setState(!item.getState());
							//Changed By Pankaj T. on 28-04-2020 resolved issue in workflow approve & rejected tree when for context2 against multiple feed & left side panel display only single feed
							e12MenuPanel.e12Workflow.openWorkflw(item, selectedTreeIndex);
						}
						else
						{
							E12CommonUtils.printOnConsole("When select the workflow tree  item == null item[" +  item + "] event [" + event + "]");
						}
					}
				}
				catch (Exception e)
				{
					E12CommonUtils.printOnConsole( "Exception :: When select the Workflow tree ["+e.toString()+"]");
					e.printStackTrace();
				}
			}
		});
		//Added by Prajyot on 06AUG2015[W15DSUN015 - Social Enterprise Platform]
		treeSelectionHandlers.put("SOCIAL", new SelectionHandler<TreeItem>() {
			Long clickTimeSpan = null;
			@Override
			public void onSelection( SelectionEvent<TreeItem> event )
			{
				E12Global.getInstance().setSocialPanel(true);//Added by Pankaj R on 06-Jan-17 for UI changes related to only Social
				try
				{
					final E12TreeItem item = (E12TreeItem) event.getSelectedItem();
					E12CommonUtils.printOnConsole("selectedItem["+ (item!=null? item.getTreeItemID():item ) +"]");
					//Added by Amol Sant on 17-07-17 for E12Groups [START]
					String id = item.getElement().getId();
					if("create_grp".equals(id))
					{

						e12Groups.init();
						return;
					}
					//Added by Amol Sant on 17-07-17 for E12Groups [END]

					//Added by Pankaj R to detect click from MyCircle to other menu. [START]
					if(! item.getTreeItemID().equalsIgnoreCase("social_mycircles"))
					{
						E12Global.getInstance().setTreeId("");
					}
					//Added by Pankaj R to detect click from MyCircle to other menu. [END]
					Date date= new Date();
					Long clickTime = date.getTime();
					if( clickTimeSpan == null || clickTimeSpan < new Date().getTime() || clickTimeSpan.equals( new Date().getTime() ) )
					{
						clickTimeSpan = clickTime + 500;
						if(( item != null ) && ( item.getChildCount() == 0 ) )
						{
							if( lastSelectedExplItem != null )
							{
								lastSelectedExplItem.removeClassName("menuSelected-violet");
							}
							com.google.gwt.dom.client.NodeList<com.google.gwt.dom.client.Node> nodeList = item.getElement().getChildNodes();
							if( nodeList!=null && nodeList.getLength() > 0 )
							{
								Element element = nodeList.getItem(0).cast();
								if( element != null )
								{
									element.addClassName("menuSelected-violet");
									lastSelectedExplItem = element;
								}
							}
							//Added by Amol S. 07-06-17 to show MyCircle START
							try
							{
								//Added by Pankaj R to detect click from MyCircle to other menu. [START]
								String selectedTreeId = E12CommonUtils.checkNull(E12Global.getInstance().getTreeId());
								if( item.getTreeItemID().equalsIgnoreCase("social_myspace"))
								{
									e12MenuPanel.e12SocialMenu.openMySpace(item);
									return;
								}
								else if( item.getTreeItemID().equalsIgnoreCase("social_mycircles")
										|| selectedTreeId.equalsIgnoreCase("social_mycircles"))
								{
									//Added by Pankaj R to detect click from MyCircle to other menu. [END]
									e12MenuPanel.e12SocialMenu.openSocialCircle(item);
									return;
								}
							}
							catch (Exception e)
							{
								E12CommonUtils.printOnConsole("### Exception in BaseE12() :: e12MenuPanel.e12SocialMenu.openSocialCircle() : "+e);
								e.printStackTrace();
							}
							//Added by Amol S. 07-06-17 END
							e12MenuPanel.e12SocialMenu.openSocialItem(item);
						}
						else if( item != null )
						{
							if( lastSelectedExplItem != null )
							{
								lastSelectedExplItem.removeClassName("menuSelected-violet");
							}

							com.google.gwt.dom.client.NodeList<com.google.gwt.dom.client.Node> nodeList = item.getElement().getChildNodes();
							if( nodeList!=null && nodeList.getLength() > 0 )
							{
								Element element = nodeList.getItem(0).cast();
								if( element != null )
								{
									com.google.gwt.dom.client.Node chNode = element.getChild(0);
									if( chNode != null && chNode.getFirstChild() != null && chNode.getFirstChild().getChildCount() >= 2 )
									{
										com.google.gwt.dom.client.Node tNode = chNode.getFirstChild().getChild(1).getFirstChild();
										Element treeDiv = tNode.cast();
										treeDiv.addClassName("menuSelected-violet");
										lastSelectedExplItem = treeDiv;
										if(item.getState())
										{
											treeDiv.removeClassName("upArrow");
										}
										else
										{
											treeDiv.addClassName("upArrow");
										}
									}
								}
							}
							item.setState(!item.getState());
							e12MenuPanel.e12SocialMenu.openSocialItem(item);
						}
						else
						{
							E12CommonUtils.printOnConsole("When select the social tree  item == null item[" +  item + "] event [" + event + "]");
						}
					}
				}
				catch (Exception e)
				{
					E12CommonUtils.printOnConsole( "Exception :: When select the social tree ["+e.toString()+"]");
					e.printStackTrace();
				}
			}
		});

		treeSelectionHandlers.put("BULLETIN", new SelectionHandler<TreeItem>() {
			@Override
			public void onSelection( SelectionEvent<TreeItem> event )
			{
				E12Global.getInstance().setSocialPanel(true);
				TreeItem item = event.getSelectedItem();
				if( item != null )
				{
					// Added by Dnyaneshwar chavan on 26-Apr-14 [ Hide the E12Intro popup panel] Start
					E12CollabDataWrapper e12CollabDataWrapper = ( E12CollabDataWrapper )item.getUserObject();
					openBulletinBoard ( e12CollabDataWrapper );
				}
			}
		});

		treeSelectionHandlers.put("FAVORITE", new SelectionHandler<TreeItem>() {
			Long clickTimeSpan = null;
			@Override
			public void onSelection( SelectionEvent<TreeItem> event )
			{
				E12Global.getInstance().setSocialPanel(false);
				if(e12MenuPanel.e12TransMenu.count == 0)
				{
					lastSelectedExplItem = e12MenuPanel.e12TransMenu.lastSelectedExplItem;
					e12MenuPanel.e12TransMenu.count++;
				}
				//Added by Reema on 16-mar-15 [open first menu from tree default]-End
				Date date= new Date();
				Long clickTime = date.getTime();
				if( clickTimeSpan == null || clickTimeSpan < clickTime || clickTimeSpan.equals( clickTime ) )
				{
					clickTimeSpan = clickTime + 500;
					if(E12Global.isGalaxy())
					{
						TreeItem item = event.getSelectedItem();
						openFavouriteMenuTransaction( item );
					}
					else
					{
						TreeItem item = event.getSelectedItem();
						openFavourite(item);
					}
				}
			}
		});

		E12CommonUtils.printOnConsole(".........3.7");
		if( E12Global.isGalaxy() ) //Theme is Galaxy no need to load accordians
		{
			//TODO:
			//commented and added by by Vishal Pathare on 12-AUG-2016 for[changing UI] Start
			//e12Docklayout.setWidgetSize(e12HeaderPanel, 168);
			//E12Global.HEADER_PANEL_HEIGHT = 168;
			//Changed by Ajinkya D on 01-Feb-2017[To remove the gap between application and menu panel][START]
			//e12Docklayout.setWidgetSize(e12HeaderPanel, 150);
			e12Docklayout.setWidgetSize(e12HeaderPanel, 144);
			//Changed by Ajinkya D on 01-Feb-2017[To remove the gap between application and menu panel][END]
			E12Global.HEADER_PANEL_HEIGHT = 150;
			//commented and added by by Vishal Pathare on 12-AUG-2016 for[changing UI] End.
			//Added by Reema on 18-feb-15 [set class for header Element]
			Element headerPnlEle = e12HeaderPanel.getElement().getParentElement();
			headerPnlEle.setClassName("galaxy_e12HeaderPanel");
			//Added by Reema on 18-feb-15 [set class for header Element]-End
			// Commented and Add by Dnyaneshwar Chavan on 2-Nov-15[ Implement Super Dev Mode ] Start
			//e12Docklayout.setWidgetSize(e12MenuPanel, 270);
			e12SplitLytPanel.setWidgetSize(e12MenuPanel, 270);
			// added by mahesh saggam on 10-OCT-19 [to add poppanel which slides in and out the menupanel on maximize]  Start
			e12SplitLytPanel.getWidget(2).getElement().getParentElement().addClassName("explorerTrans");
			// added by mahesh saggam on 10-OCT-19 [to add poppanel which slides in and out the menupanel on maximize]  End
			e12SplitLytPanel.forceLayout();
			// Commented and Add by Dnyaneshwar Chavan on 2-Nov-15[ Implement Super Dev Mode ] End
			E12Global.MENU_PANEL_WIDTH = 270;
			E12CommonUtils.printOnConsole(".........3.8.1.END");
			Resources.INSTANCE.museoLight300().ensureInjected();
			//Added by Prajyot on 06AUG2015[W15DSUN015 - Social Enterprise Platform]
			Resources.INSTANCE.socialCss().ensureInjected();
		}
		else //Theme is non-Galaxy need to load accordians
		{
			e12Docklayout.setWidgetSize(e12HeaderPanel, 51);
			E12Global.HEADER_PANEL_HEIGHT = 0;
			e12MenuPanel.loadAccordians(new Callback<String, String>() {
				@Override
				public void onFailure(String reason)
				{

				}

				@Override
				public void onSuccess(String result)
				{
					if (e12MenuPanel.accordList.contains("EXPLORER"))
					{
						e12MenuPanel.e12TransMenu.getTree( E12Constants.profileID, E12Constants.conApplNm);
						e12MenuPanel.e12TransMenu.tree.getElement().setId("baseE12-e12transMenutree");
						e12MenuPanel.e12TransMenu.tree.addSelectionHandler(treeSelectionHandlers.get("EXPLORER"));
					}
					if (e12MenuPanel.accordList.contains("WORKFLOW"))
					{
						e12MenuPanel.e12Workflow.getTree( E12Constants.profileID, E12Constants.conApplNm );
						e12MenuPanel.e12Workflow.wrkflwTree.getElement().setId("baseE12-e12Wrkflwtree");
						e12MenuPanel.e12Workflow.wrkflwTree.addSelectionHandler(treeSelectionHandlers.get("WORKFLOW"));
						e12MenuPanel.refreshBtn.addDomHandler(new ClickHandler() {
							@Override
							public void onClick(ClickEvent event) {
								e12MenuPanel.e12Workflow.getTree( E12Constants.profileID, E12Constants.conApplNm );
								E12CommonUtils.getInstance().getWorkFlowPendingCount(0);
							}
						}, ClickEvent.getType());
					}
					if (e12MenuPanel.accordList.contains("BULLETIN"))
					{
						Resources.INSTANCE.collabCss().ensureInjected();
						e12MenuPanel.e12CollabMenu.getTree();
						e12MenuPanel.e12CollabMenu.collabTree.addSelectionHandler(treeSelectionHandlers.get("BULLETIN"));
						e12MenuPanel.refreshBtnCollab.getElement().setId("baseE12-e12MenuRefresh");
						e12MenuPanel.refreshBtnCollab.addDomHandler(new ClickHandler() {
							@Override
							public void onClick(ClickEvent event) {
								e12MenuPanel.e12CollabMenu.getTree();
							}
						}, ClickEvent.getType());
					}
					if (e12MenuPanel.accordList.contains("FAVORITE"))
					{
						e12MenuPanel.e12FavouriteMenu.getTree();
						e12MenuPanel.e12FavouriteMenu.favouriteTree.getElement().setId("baseE12-e12favMenu");
						e12MenuPanel.e12FavouriteMenu.favouriteTree.addSelectionHandler(treeSelectionHandlers.get("FAVORITE"));
					}
				}
			});
			E12CommonUtils.printOnConsole(".........3.8.2.END");
		}
		//Added by Prasad on 03/04/15 [for set shortcut for transaction] START
		e12TransBrow.e12TabPanel.getElement().setId("baseE12-e12tabPnl");
		//Added by Pankaj R on 06-Jan-17 for UI changes to remove top margin.[START]
		//Change by shrutika on 19-04-19 for Current screens have -ve values or % values in CSS cousing alignment issues.
		//e12TransBrow.e12TabPanel.getElement().setAttribute("style", "margin-top: -1px;");
		e12TransBrow.e12TabPanel.getElement().setAttribute("style", "margin-top: 0px !important;");
		//Added by Pankaj R on 06-Jan-17 for UI changes to remove top margin.[END]
		e12TransBrow.e12TabPanel.addSelectionHandler(new SelectionHandler<Integer>() {

			@Override
			public void onSelection(SelectionEvent<Integer> event)
			{
				E12CommonUtils.printOnConsole("In SelectionHandler...........["+event.getSelectedItem()+"]");
				e12TransBrow.e12TabPanel.selectTab();
			}
		});
		//Added by Prasad on 03/04/15 [for set shortcut for transaction] START

		initWidget( outer );
		removeElementByClassName("gwt-SplitLayoutPanel-HDragger", true);
		addCommunicator(new E12CommunicatorImpl());
		//Added by Prasad on 05/02/16 [for Tagging - get all tag values - B15FSUN004]
		getAllTagValues();
		// Added by Pravin K on 19-FEB-18 [To hide social and workflow icon] START
		hideFeatures();
		// Added by Pravin K on 19-FEB-18 [To hide social and workflow icon] END
	}

	public BaseE12( boolean dummy )
	{

	}

	/**
	 * This method is used to generate random no for userID.
	 * @return randomeID
	 */
	private int generateRandomNo()
	{
		//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] START
		/*int randNo = -1;
		randNo = (int)( Math.random() * 1000000000 ) + 1;
		return randNo;*/
		return E12CommonUtils.getInstance().generateRandomNo();
		//Chnaged by Prasad on 09/01/2021 [use common method for randomNo generation] END
	}

	//Added By Prajyot P. Rumde on 11-08-2011 [RnD] Starts
	protected void loadProfileFromServlet(String userId) {

		E12CommonUtils.printOnConsole(".........3.5.1");
		//Changed By Mahesh Patidar on 28/DEC/12
		HashMap<String, String> paramMap = new HashMap<String, String>();

		paramMap.put("action", "GETTABS");
		paramMap.put("userId", userId);
		String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);

//		String objActionPath = MELogin.hostUrl + "/ibase/ProfileServiceServlet?action=GETTABS&userId="
//				+ userId;
		//String objActionPath = MELogin.hostUrl + "/ibase/ProfileServiceServlet?" + paramString;
		//Ended By Mahesh Patidar

		//START ADDED By Harshada [LOGIN BASED ON SELECTED CONNECTION] on 8 JAN 2013
		String objActionPath = E12Global.getHostUrl() + "/ibase/ProfileServiceServlet?" + paramString;
		//END ADDED By Harshada [LOGIN BASED ON SELECTED CONNECTION] on 8 JAN 2013

		RequestBuilder reqBuilder = new RequestBuilder(RequestBuilder.GET,
				objActionPath);
		try {
			reqBuilder.sendRequest(null, new RequestCallback() {
				@Override
				public void onError(Request request, Throwable exception) {
					Window.alert("Error :"+exception.getMessage());
				}

				@Override
				public void onResponseReceived(Request request,
						Response response) {
					// TODO Auto-generated method stub
					if (!response.getText().equals("")) {
						try {
							// Added BY Arvind on 7-FEB-2014 : To Maintain session time out
							if( E12Global.getInstance().checkErrorException(response, 1) )
							{
								List<TabDTO> tabs = getUnmarshalledTabs(response.getText());
								refreshDashboard(tabs);
							}
						} catch (Exception e) {
							e.printStackTrace();
							E12CommonUtils.printOnConsole("Exception in loadProfileFromServlet:" + e.getMessage()); // Changes by Ajinkya Gopalkar
						}
					}
					else
					{
						E12CommonUtils.printOnConsole( request.toString()+ " request:response "+ response.getStatusText() + " : " + response.getText()); // Changes by Ajinkya Gopalkar
					}
				}
			});
			E12CommonUtils.printOnConsole(".........3.5.2");

		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
			E12CommonUtils.printOnConsole(".........3.5.1 Exception");
		}
	}

	private  List<TabDTO> getUnmarshalledTabs(String tabXml) {
		List<TabDTO> tabs = null;
		Document document = XMLParser.parse(tabXml);
		//dashboradPage <=> tab
		NodeList actionInfoNodeLst = document.getElementsByTagName("dashboradPage");
		//Added check for nodelist length.
		//if (actionInfoNodeLst.getLength() > 0) {
		if (actionInfoNodeLst != null && actionInfoNodeLst.getLength() > 0) {
			tabs = new ArrayList<TabDTO>();
			TabDTO tab = null;
			ScreenDTO screen = null;
		//Added By kamal on Jun 14 2019 [To store TabId and dbrResource in Array to redirect dashboard based on metadaNama Start]	
			JSONArray userDashboardList = new JSONArray();
			for (int pageIndex = 0; pageIndex < actionInfoNodeLst.getLength(); pageIndex++)
			{
				Node t = actionInfoNodeLst.item(pageIndex);
				tab = new TabDTO();
				//Added By kamal on Jun 14 2019 [To store TabId and dbrResource in Object to redirect dashboard based on metadaNama Start]	
				JSONObject dashboardInfo = new JSONObject();
				NodeList tabPropList = t.getChildNodes();
				for (int j = 0; j < tabPropList.getLength(); j++)
				{
					Node tp = tabPropList.item(j);
					//dashboardComp <=> screens
					if (tp.getNodeName().equals("dashboardComp"))
					{
						screen = new ScreenDTO();
						NodeList screenPropList = tp.getChildNodes();
						for (int k = 0; k < screenPropList.getLength(); k++)
						{
							Node sp = screenPropList.item(k);
							if (sp.getNodeName().equals("columnNo")) {
								screen.setColumnNo(new Integer(sp
										.getFirstChild().toString()));
							} else if (sp.getNodeName().equals("height")) {
								screen.setHeight(new Integer(sp.getFirstChild()
										.toString()));
							} else if (sp.getNodeName().equals("rowNo")) {
								screen.setRowNo(new Integer(sp.getFirstChild()
										.toString()));
							} else if (sp.getNodeName().equals("screenId")) {
								screen.setScreenId(new Long(sp.getFirstChild()
										.toString()));
							} else if (sp.getNodeName().equals("tabId")) {
								screen.setTabId(new Long(sp.getFirstChild()
										.toString()));
								dashboardInfo.put("pageId",new JSONString(sp.getFirstChild()
										.toString()));
							} else if (sp.getNodeName().equals("title")) {
								screen.setTitle(sp.getFirstChild().toString());
							} else if (sp.getNodeName().equals("uri")) {
								screen.setUri( sp.getFirstChild().getNodeValue() );
							} else if (sp.getNodeName().equals("userId")) {
								screen.setUserId(sp.getFirstChild().toString());
							} else if (sp.getNodeName().equals("width")) {
								screen.setWidth(new Integer(sp.getFirstChild().toString()));
							}
							//Changed by yogesh on 31-Jan-2012 [dashboard for mfs] start
							else if (sp.getNodeName().equals("compName")) {
								screen.setCompName(sp.getFirstChild().toString());
							}
							else if (sp.getNodeName().equals("compType")) {
								screen.setCompType(sp.getFirstChild().toString());
							}
							//Changed by yogesh on 31-Jan-2012 [dashboard for mfs] end
							//Added By Prashant Chavan on 04-Feb-15  [Req:W14HSUN001 for Dashboard Report type] Start
							else if (sp.getNodeName().equals("dbrResource")) {
								screen.setDbrResource(sp.getFirstChild().toString());
								dashboardInfo.put("dbrResource",new JSONString(sp.getFirstChild().toString()));
							}
							//Added By Prashant Chavan on 04-Feb-15  [Req:W14HSUN001 for Dashboard Report type] End
							//Added by Anjali R. [Start]
							else if (sp.getNodeName().equals("dataModel"))
							{
								E12CommonUtils.printOnConsole("Suraj 765 -- BaseE12 dataModel name is ["+sp.getFirstChild().toString()+"]");
								screen.setDataModel(sp.getFirstChild().toString());
							}
							//Added by Anjali R. [End]
							//Added by Jatin M. on 09-04-21 for displaying default Dashboard as per selected application [Start]
							else if (sp.getNodeName().equals("defaultAppl"))
							{
								E12CommonUtils.printOnConsole("BaseE12-getUnMarshalledTabs-defaultAppl::["+sp.getFirstChild().toString()+"]");
								screen.setDefaultApplication(sp.getFirstChild().toString());
							}
							//Added by Jatin M. on 09-04-21 for displaying default Dashboard as per selected application [End]
						}
						tab.addScreen(screen);
					} else if (tp.getNodeName().equals("imageUri")) {
						tab.setImageUri(tp.getFirstChild().toString());
					} else if (tp.getNodeName().equals("tabId")) {
						tab.setTabId(new Long(tp.getFirstChild().toString()));
					} else if (tp.getNodeName().equals("uri")) {
						tab.setUri(tp.getFirstChild().toString());
					} else if (tp.getNodeName().equals("userId")) {
						tab.setUserId(tp.getFirstChild().toString());
					}else if (tp.getNodeName().equals("title")) {
						tab.setTitle(tp.getFirstChild().toString());
					}
					//Added By Prashant Chavan on 04-Feb-15  [Req:W14HSUN001 for Dashboard Report type] Start
					else if (tp.getNodeName().equals("compType")) {
						tab.setCompType(tp.getFirstChild().toString());
					}
					//Added By Prashant Chavan on 04-Feb-15  [Req:W14HSUN001 for Dashboard Report type] End
				}
				dashboardInfo.put("pageIndex",new JSONString((pageIndex+1) +""));
				userDashboardList.set(userDashboardList.size(),dashboardInfo);
				tabs.add(tab);
			}
			E12Storage.setItemLocalStorage("dashboard_list", userDashboardList.toString());
			//Added By kamal on Jun 14 2019 [To store TabId and dbrResource in Array to redirect dashboard based on metadaNama] End
		}
		return tabs;
	}

	protected void refreshDashboard(List<TabDTO> tabs)
	{
		E12CommonUtils.printOnConsole(".........3.5.1.1");
		//Added by shrutika on 28-03-19 for Implement on shift + tab functionality to switch open tab.
		E12CommonUtils.getInstance().setTabShortcutkey();
		if (tabs.size() > 0)
		{
			System.out.println("Loading Client...");
		  	//Added by Dnyaneshwar Chavan on 31-Nov-15 [ Dashboard widgets not resize ] Start
			//CustomTabLayoutWidget custTabLayoutWidget = new CustomTabLayoutWidget(tabs);
			custTabLayoutWidget = new CustomTabLayoutWidget(tabs);
		  	//Added by Dnyaneshwar Chavan on 31-Nov-15 [ Dashboard widgets not resize ] End
			//Changes By Prajyot On 16-09-2011 [For Dashboard Tab Title - "Welcome" replaced by "Dashboard"]
			//e12TransBrow.e12TabPanel.add( new CustomTabLayoutWidget(tabs), constants.setDashboardLbl() ,true);
			//Changed By Mahesh Patidar on 01/JUL/13 [for dashboard panel view indepndently]
			if(!isDashboardCaller)
			{
				/*Added by Pankaj R on 19-Jan-17 to show direct panel if only one tab is present [START]*/
				e12TransBrow.e12TabPanel.getElement().setId("e12TransBrow_e12TabPanelId");
				e12TransBrow.e12TabPanel.addTab( custTabLayoutWidget, getTabWidget(custTabLayoutWidget, constants.setDashboardLbl(), false), constants.setDashboardLbl() );
				if(tabs.size() == 1)
				{
					Element tabDashboardElem = DOM.getElementById("tab_Dashboard").getFirstChildElement().getFirstChildElement();
					if(tabDashboardElem != null)
						tabDashboardElem.setAttribute("style", "display: none");

					Element childElem = (Element) DOM.getElementById("tab_Dashboard").getChild(1);
					if(childElem != null)
						childElem.setAttribute("style", "top: 1px !important;");
				}
				/*Added by Pankaj R on 19-Jan-17 to show direct panel if only one tab is present [END]*/
			}
			else
			{
				try
				{
					custTabLayoutWidget.setWidth(Window.getClientWidth() + "px");
					custTabLayoutWidget.setHeight(Window.getClientHeight() + "px");
					dashboardPanel.clear();
					dashboardPanel.add(custTabLayoutWidget);
					((CustomTabLayoutWidget)dashboardPanel.getWidget(0)).selectTab(0);
				}
				catch(Exception e)
				{
				}

			}
		}
		else
		{
			HTMLPanel htmlPanel = new HTMLPanel( constants.setWelcomeMsgLbl() );
			//Changes By Prajyot On 16-09-2011 [For Dashboard Tab Title - "Welcome" replaced by "Dashboard"]
			if(!isDashboardCaller)
			{
				e12TransBrow.e12TabPanel.addTab( htmlPanel, getTabWidget(htmlPanel, constants.setDashboardLbl(), false), constants.setDashboardLbl() );
			}
			else
			{
				dashboardPanel.add(htmlPanel);
			}
		}
		
		if( ! isDashboardCaller )
		{
			//Added by Jatin M. on 09-04-21 for displaying default Dashboard as per selected application [Start]
			TabBar tabPanel = custTabLayoutWidget.tabPanel.getTabBar();
            E12CommonUtils.printOnConsole("tabPanel isDashboardCaller::["+tabPanel+"]");
            try 
            {
            	//Added by Jatin on 15/04/2021 [Load dashboard on application change]
            	e12TransBrow.e12TabPanel.selectTab( 0 );
            	
                int selectedDashboard = 0;
                if(tabPanel != null)
                {
                    for ( int i = 0; i < tabPanel.getTabCount(); i++ )
                    {
                        //boolean selected = false;
                        TabDTO tabDTO = custTabLayoutWidget.getTabPanelWidgetHM().get(i);
                      //Added by Jatin on 15/04/2021 [Load dashboard on application change] START
                        if ( tabDTO == null )
                        {
                        	continue;
                        }
                      //Added by Jatin on 15/04/2021 [Load dashboard on application change] END
                        Set<ScreenDTO> screensDTO = tabDTO.getScreens();
                      //Added by Jatin on 15/04/2021 [Load dashboard on application change] START
                        if ( screensDTO == null )
                        {
                        	continue;
                        }
                      //Added by Jatin on 15/04/2021 [Load dashboard on application change] END
                        screensDTO = new TreeSet<ScreenDTO>(screensDTO);
                        for(ScreenDTO s : screensDTO)
                        {
                            //E12CommonUtils.printOnConsole("In refreshDashboard applgroup::["+E12Constants.applicationGroup+"]::["+s.getDefaultApplication()+"]:tabPanel.getTabCount():["+tabPanel.getTabCount()+"]");
                            String applGroup = E12Global.checkNull(s.getDefaultApplication());
                            String[] multiApplGroup = applGroup.split(",");
                            if(multiApplGroup.length > 1)
                            {
                                for(String applGrp : multiApplGroup)
                                {
                                    //E12CommonUtils.printOnConsole("In refreshDashboard applGrp if::["+applGrp+"]::["+selectedDashboard+"]");
                                    if(E12Constants.applicationGroup.equalsIgnoreCase(applGrp.trim()))
                                    {
                                        custTabLayoutWidget.selectTab(i);
                                        //selected = true;
                                        selectedDashboard++;
                                        break;
                                    }
                                }
                            }
                            else
                            {
                                if(E12Constants.applicationGroup.equalsIgnoreCase(applGroup.trim()))
                                {
                                    //E12CommonUtils.printOnConsole("In refreshDashboard applGroup else::["+applGroup+"]::["+selectedDashboard+"]");
                                    custTabLayoutWidget.selectTab(i);
                                    //selected = true;
                                    selectedDashboard++;
                                    break;
                                }
                            }
                        }
                        if(selectedDashboard > 0)
                        {
                            //E12CommonUtils.printOnConsole("The boolean value is selectApplication::["+selectedDashboard+"]");
                            break;
                        }
                    }
                }
                if(selectedDashboard == 0)
                {
                    //E12CommonUtils.printOnConsole("In refreshDashboard i ::::["+selectedDashboard+"]");
                    e12TransBrow.e12TabPanel.selectTab( 0 );
                    //Added By Prashant Chavan for selecting the first dashboard by default on 25-Feb-15 Start
                    ((CustomTabLayoutWidget)e12TransBrow.e12TabPanel.getWidget(0)).selectTab(0);
                    //Added By Prashant Chavan for selecting the first dashboard by default on 25-Feb-15 End 
                }
            }
            catch(Exception e)
            {
                E12CommonUtils.printOnConsole("Exception in selecting Dashboard refreshDashboard::["+e.getMessage()+"]");
            }
            //Added by Jatin M. on 09-04-21 for displaying default Dashboard as per selected application [End]
			BaseE12.e12MenuPanel.e12TransMenu.toSelectItemID = constants.setDashboardLbl();
		}
		E12CommonUtils.printOnConsole(".........3.5.1.1.END");
		//Ended By Mahesh Patidar
	}
	//Added By Prajyot P. Rumde on 11-08-2011 [RnD] Ends

	//Added By Dnyaneshwar chavan on 05-11-2012 [WS2GBAS013] Start
	/**
	 * This method is use to set the title & close btn on the tab Panel
	 *
	 * @param widget's a given widget
	 * @param title's a given title
	 * @return widget's Horizontal panel
	 * */
	 public Widget getTabWidget(final Widget widget, final String title) {
		 return getTabWidget(widget, title, true);
	 }

	 public Widget getTabWidget(final Widget widget, final String title, boolean isClosable)
	 {

	    final HorizontalPanel hPanel = new HorizontalPanel();
	    final Label label = new Label(title);
	    label.setStyleName("tabHeaderLabel");
	    //Added by Prajyot on 4JUN13 [Bug fixing : On click of Close Other, other than selected tabs get close and title of Selected tab gets changed ]
	    //label.getElement().setId("selectedTabTitle");
	    HTML html = new HTML("<selectedtabtitle>" + title + "</selectedtabtitle>");
	    DOM.setStyleAttribute(html.getElement(), "visibility", "hidden");
	    DOM.setStyleAttribute(html.getElement(), "display", "none");
	    DOM.appendChild( hPanel.getElement(), html.getElement() );
//	    DOM.setStyleAttribute(label.getElement(), "whiteSpace", "nowrap");
//	    DOM.setStyleAttribute(label.getElement(), "color", "white");

	    final Label closeBtn = new Label("x");
	    //closeBtn.setResource(images.cross());
	    closeBtn.setStyleName("defaultTabCloseBtn");
		closeBtn.getElement().setId("baseE12-close");
	    closeBtn.addMouseOverHandler(new MouseOverHandler() {

			@Override
			public void onMouseOver(MouseOverEvent event) {
				closeBtn.removeStyleName("defaultTabCloseBtn");
				closeBtn.setStyleName("tabCloseBtn");

			}
		});
	    closeBtn.addMouseOutHandler(new MouseOutHandler() {

			@Override
			public void onMouseOut(MouseOutEvent event) {
				closeBtn.removeStyleName("tabCloseBtn");
				closeBtn.setStyleName("defaultTabCloseBtn");
			}
		});
	    closeBtn.addClickHandler(new ClickHandler() {
	        public void onClick(ClickEvent event) {
	            int widgetIndex = e12TransBrow.e12TabPanel.getWidgetIndex(widget);
	            int widgetSelectedIndex = e12TransBrow.e12TabPanel.getSelectedTab();
	            //int widgetSelectedIndex = 1;

	            closeTab();
	            if (widgetIndex == widgetSelectedIndex ) {
	            	e12TransBrow.e12TabPanel.selectTab(widgetIndex - 1);
	            }
	            e12TransBrow.e12TabPanel.remove( widgetIndex );
	        }
	    });

	    if( isClosable )
	    {
	    	hPanel.add(label);
	    	hPanel.add(new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
	    	hPanel.add(closeBtn);
	    }
	    else
	    {
	    	hPanel.add(label);
	    }
	    hPanel.setStyleName("gwt-TabLayoutPanelTab");
	    E12CommonUtils.printOnConsole("Inside getTabWidget 1118");
	    return hPanel;
	 }

	/**
	 * This method is remove the instance
	 * */
	public void closeTab()
	{
		int selectedTab = BaseE12.e12TransBrow.e12TabPanel.getSelectedTab();
		try{
			VerticalPanel e12PnlGen =  ( VerticalPanel ) ( BaseE12.e12TransBrow.e12TabPanel.getWidget( selectedTab ) );
			TextBox tbID = ( TextBox ) e12PnlGen.getWidget( 1 );

			//Changed By Prajyot P. Rumde on 11-08-2011 [RnD]
			//if( BaseE12.e12TransBrow.e12TabPanel.getTabBar().getTabHTML( selectedTab ).equalsIgnoreCase( "Welcome" ) )
			if( BaseE12.e12TransBrow.e12TabPanel.getTabHTML( selectedTab ).equalsIgnoreCase( "Welcome" ) )
			{
				return;
			}
			E12CommonUtils.printOnConsole( "closeTab tabsMap["+tabsMap.toString()+"]" );
			String path ="/ibase/InstanceRemoveServlet?EDITOR_ID=" + BaseE12.tabsMap.get( E12Constants.userID + tbID.getText().trim() ) + "&OBJ_NAME=" + E12Constants.objName  + "&dummyInt=" + Math.random();
			BaseE12.tabsMap.remove( E12Constants.userID + tbID.getText().trim() ); //Added by Dnyaneshwar Chavan on 22-DEC-14 [ When click on same object that time instance not remove ]
			RequestBuilder requestBuilder = new RequestBuilder( RequestBuilder.GET, path );
			try
			{
				requestBuilder.sendRequest( null, new RequestCallback()
				{
					public void onError( Request request, Throwable exception )
					{
						Window.alert( constants.setErrMsgAlt() );
					}
					public void onResponseReceived( Request request, Response response )
					{
						// Added BY Arvind on 7-FEB-2014 : To Maintain session time out
						if( E12Global.getInstance().checkErrorException(response, 1) )
						{
							GWT.runAsync( new RunAsyncCallback()
							{
								public void onSuccess()
								{
								}
								public void onFailure( Throwable reason )
								{
//									Changed by Savita Yadav on 18-05-2015 [For Code download terminated issue]
//									Window.alert( constants.setErrMsgAlt() + " :: " + reason.getMessage() );
									Window.alert( constants.setClearCacheAndLogin() );
								}
							});
						}
					}
				});
			}
			catch( RequestException ex )
			{
				Window.alert( constants.setExceptionAlt() + " " + ex.getMessage() + "]" );
				System.out.println( constants.setExceptionAlt() + " : " + ex.getMessage() );
			}
		}
		catch(Exception e){
			// Do Nothing
		}
	}
	//Added By Mahesh Patidar on 01/JUL/13 [to set E12Constants values]
		private void setE12Constants()
		{
			try
			{
				//Added by Pankaj T. on 16-11-18 for console configuration if 1 then print console only [START]
				E12Constants.clientDebugLevel = DOM.getElementById( "clientDebugLevel" ).getInnerText();
				E12CommonUtils.log("clientDebugLevel in BaseE12:["+E12Constants.clientDebugLevel+"]");
				//Added by Pankaj T. on 16-11-18 for console configuration if 1 then print console only [END]
				//Added By Pankaj T. on 18-11--2020 for removing weak account lock vulnerability - if user wrongly enter password more than 5 times then lock the account and send new password on email/mobile and unlock account using new password   
				E12Constants.wrongLoginCount = DOM.getElementById( "wrongLoginCount" ).getInnerText();
				E12Constants.userID = DOM.getElementById( "userID" ).getInnerText();
				E12Constants.siteCode = DOM.getElementById( "siteCode" ).getInnerText();
				//Added by Pankaj R on 14-11-17 for enterprise logo [START]
				E12Constants.enterprise = DOM.getElementById( "enterprise" ).getInnerText();
				//Added by Pankaj R on 14-11-17 for enterprise logo [END]
				//Added by Jay -To get social opt from DOM - Start
				E12Constants.social_opt = DOM.getElementById( "social_opt" ).getInnerText();
				//Added by Jay -To get social opt from DOM - End
				E12Constants.profileID = DOM.getElementById( "profileID" ).getInnerText();
				E12Storage.localStorageVars.add("userName");
				E12Storage.localStorageVars.add("siteCode");
				E12Storage.localStorageVars.add("enterprise");
				E12Storage.localStorageVars.add("profileID");
				E12Storage.setItem("userName", E12Constants.userID);
				E12Storage.setItem("siteCode", E12Constants.siteCode);
				E12Storage.setItem("enterprise", E12Constants.enterprise);
				E12Storage.setItem("profileID", E12Constants.profileID);

				//Added by Sainath T. on 11-JUN-19 [For Cross site scripting filter]-Start
				E12Constants.xssFilter = DOM.getElementById( "xssFilter" ).getInnerText();
				//Added by Sainath T. on 11-JUN-19 [For Cross site scripting filter]-End

				E12CommonUtils.log("IN BaseE12 userId:["+E12Constants.userID+"]");
				E12CommonUtils.log("IN BaseE12 siteCode:["+E12Constants.siteCode+"]");
				//Added by Reema on 13/06/14 [change user password]
				//E12Constants.passwordSha256=DOM.getElementById("loginPwd").getInnerText();
				//Added by Pankaj T. on 16-07-20202 for removing vulnerability of Insecure password Storage - start
				setPwdSHA256();
				//Added by Pankaj T. on 16-07-20202 for removing vulnerability of Insecure password Storage - end
				//Added by Reema on 13/06/14 [change user password]-End
				//	E12Constants.applnName = DOM.getElementById( "applnName" ).getInnerText();
				E12Constants.welcomeMsg = DOM.getElementById( "welcomeMsg" ).getInnerText();
				E12Constants.empDesignation = DOM.getElementById( "empDesignation" ).getInnerText();
				E12Constants.empDivision = DOM.getElementById( "empDivision" ).getInnerText();
				E12Constants.empHeadQuat = DOM.getElementById( "empHeadQuat" ).getInnerText();
				E12Constants.empDOJ = DOM.getElementById( "empDOJ" ).getInnerText();
				//Added By Lokesh Rodge on 24-Apr-2013
				E12Constants.empName=DOM.getElementById("empName").getInnerText();
				E12Constants.empCode=DOM.getElementById("empCode").getInnerText();
				//End

				//Added by Dnyaneshwar Chavan on 30-OCT-14 [ Change password not working in native interface ] Start
				E12Constants.empFName=DOM.getElementById("empFName").getInnerText();
				E12Constants.empMName=DOM.getElementById("empMName").getInnerText();
				E12Constants.empLName=DOM.getElementById("empLName").getInnerText();
				E12Constants.userLanguage=DOM.getElementById("userLanguage").getInnerText();
				E12Constants.userCountry=DOM.getElementById("userCountry").getInnerText();
				//Added by Dnyaneshwar Chavan on 30-OCT-14 [ Change password not working in native interface ] Start
				//Added by nikita on 12-Apr-17 [Date format should be as per the definition, it must read from DateFormat.xml] start
				E12Constants.dbDateFormat = DOM.getElementById( "dbDateFormat" ).getInnerText();
				E12Constants.dispDateTimeFromat = DOM.getElementById( "dispDateTimeFromat" ).getInnerText();
				//Added by nikita on 12-Apr-17 [Date format should be as per the definition, it must read from DateFormat.xml] end
				E12Constants.dispDate = DOM.getElementById( "dispDate" ).getInnerText();
				E12Constants.applDate = DOM.getElementById( "applDate" ).getInnerText();
				//Added by yogesh on 22-oct-11 [SY1GSUN001 | set formal arg.value in search option].Start
				E12Constants.deptCode = DOM.getElementById( "deptCode" ).getInnerText();
				//Added by Shrutika on 05-02-18 [Start] for getting site code and city
				E12Constants.siteDescr = DOM.getElementById( "siteDescr" ).getInnerText();
				E12Constants.city = DOM.getElementById( "city" ).getInnerText();
				//Added by Shrutika on 05-02-18 [End] for getting site code and city
				//Added by Shrutika on 14-02-18 [Start] for getting fin_entity.
				E12Constants.fin_entity = DOM.getElementById( "fin_entity" ).getInnerText();
				//Added by Shrutika on 14-02-18 [End] for getting fin_entity.
				E12CommonUtils.printOnConsole("BaseE12 setCOnstant 1095!!!!");
				//Added by Pratheek on 28-01-19[ to store the facility code value in reports]-Start
				E12Constants.facility_code = DOM.getElementById( "facility_code" ).getInnerText();
				E12CommonUtils.printOnConsole("BaseE12 setCOnstant 1101!!!!");
				//Added by Pratheek on 28-01-19[ to store the facility code value in reports]-End
				E12Constants.entityCode = DOM.getElementById( "entityCode" ).getInnerText();
				E12Constants.itemSer = DOM.getElementById( "itemSer" ).getInnerText();

				//Added By Harshada on 10 DEC 12 [Creating user connections on login]START
				E12Constants.userLevel = DOM.getElementById( "userLevel" ).getInnerText();
				E12Constants.conApplNm = DOM.getElementById("APPL_NAME").getInnerText();
				//Added By Harshada on 10 DEC 12 [Creating user connections on login]END

				//Added By Dnyaneshwar on 10-MAY-13 [Creating COC viewer] START
				E12Constants.isTNCInitiated = DOM.getElementById("isTNCInitiated").getInnerText();

				//Added By Prajyot on 05-JUN-2015 [Entity Contact Details for SSP] End
				E12Constants.allowChgAccount = DOM.getElementById("allowChgAccount").getInnerText();
				E12Constants.profileDescr =  DOM.getElementById("profileDescr").getInnerText();
				E12Constants.chgEntityDescr = E12Constants.profileDescr;

				E12Constants.isClearCache = DOM.getElementById("isClearCache").getInnerText();

				E12Constants.userTheme = DOM.getElementById( "userTheme" ).getInnerText();
				//Added by Vishal P on 11/08/16 [for //Added by Vishal Pathare on 12-AUG-2016 for[getting <ux_interface>] value for theme interface]]
				E12Constants.uxInterface = DOM.getElementById( "uxInterface" ).getInnerText();
				//Added By Ajinkya Gopalkar [on 16-Sep-15 for configure geolocation]
				E12Constants.enableGeoPosition = DOM.getElementById( "enableGeoPosition" ).getInnerText();
				//Added By Amol S on 18-Jul-17 to get userName
				E12Constants.userName = DOM.getElementById( "userName" ).getInnerText();
				//Added By Sanket J on 04/08/17 for getting userType from users
				E12Constants.userType = DOM.getElementById("userType").getInnerText();
				//Added By Sanket J on 04/08/17 for getting userType from users

				//Added by shrutika on 13-08-19 [Start] for Explore option to be added in home screen and report.
				E12Constants.licenseKey = DOM.getElementById( "licenseKey" ).getInnerText();
				E12CommonUtils.log("licenseKey in BaseE12: 1206!!!["+E12Constants.licenseKey+"]");

				// Added by Pravin K on 11-8-17 [To hide social icon] START
				E12Constants.featureOptions = DOM.getElementById("featureOptions").getInnerText();
				E12CommonUtils.printOnConsole("setE12Constants TO SET featureOptions insidefeatures="+E12Constants.featureOptions);
				// Added by Pravin K on 11-8-17 [To hide social icon] END
				if( "default".equalsIgnoreCase( E12Constants.userTheme ) )
				{
					//E12Constants.userTheme = "blue";
					//Changed by Nikita S on 15/05/17[to set default theme value to galaxy ]
					E12Constants.userTheme = "galaxy";
				}

				if( DOM.getElementById( "applDateTime" ).getInnerText() == null || "".equalsIgnoreCase(DOM.getElementById( "applDateTime" ).getInnerText()))
				{
					E12Constants.applDateTime =  "dd-MMM-yyyy HH:mm:ss";
				}
				else
				{
					E12Constants.applDateTime = DOM.getElementById( "applDateTime" ).getInnerText();
				}
				//E12CommonUtils.getInstance().updateCurrentGeoPos();
				if( E12UserInfo.getCallerInterface().equalsIgnoreCase("MOBILE") )
				{
					E12CommonUtils.getInstance().updateCurrentGeoPos();
				}
				//Added by samadhan on 18/08/2017 to implement incremental search.
				E12Constants.pageSize = Integer.parseInt(DOM.getElementById( "pageSize" ).getInnerText());
				//Added by sunny soni for getting current and upto Row Number for lazy loading in workflow[Start]
				E12Constants.uptoRowNum = Integer.parseInt(DOM.getElementById( "uptoRowNum" ).getInnerText());
                //Added by sunny soni for getting current and upto Row Number for lazy loading in workflow[End]
                //Added by Pankajt T on 14-09-2020 for The user icon which shows detail information about user should also show Login using User id/Mobile/email and user_id/mobile/email value
                E12Constants.authenticatedUsing = DOM.getElementById( "authenticatedUsing" ).getInnerText();
                //Added by Sainath T. on 29-05-19 [For Search Scope Ang Component]-Start
				E12Storage.localStorageVars.add("deptCode");
				E12Storage.localStorageVars.add("entityCode");
				E12Storage.localStorageVars.add("APPL_DATE_FORMAT");
				E12Storage.setItem("deptCode", E12Constants.deptCode);
				E12Storage.setItem("entityCode", E12Constants.entityCode);
				E12Storage.setItem("APPL_DATE_FORMAT", E12Constants.applDate);
				//Added by Sainath T. on 29-05-19 [For Search Scope Ang Component]-End
			}
			catch (Exception e)
			{
				// TODO Auto-generated catch block
				e.printStackTrace();
				E12CommonUtils.printOnConsole("Exception in setE12Constant..["+e.getMessage()+"]");
			}
		}
//		Ended By Mahesh Patidar

		private void updateStyles() {
			//Changes by Ajinkya Gopalkar on 13/FEB/2015 [changes userImage name as userImageHB]
			String prevStyle = E12HeaderPanel.userImageHB.getStyleName();
			prevStyle = prevStyle.replace("null", E12Constants.userTheme);
			E12HeaderPanel.userImageHB.setStyleName( prevStyle );

			prevStyle = E12HeaderPanel.userSetting.getStyleName();
			prevStyle = prevStyle.replace("null", E12Constants.userTheme);
			E12HeaderPanel.userSetting.setStyleName( prevStyle );
		}

		//Added By Mahesh Patidar on 01/JUL/13 [to get dashboard panel independently]
		private boolean isDashboardCaller = false;
		private VerticalPanel dashboardPanel = new VerticalPanel();
		public Widget getDashboardPanel()
		{
			try
			{
				isDashboardCaller = true;
				callerInterface = DOM.getElementById( "callerInterface" ).getInnerText();
				GWT.<Resources.ThemeResources>create( Resources.ThemeResources.class ).defaultCSS().ensureInjected();
				setE12Constants();
				setEnterpriseLogo(); //Added by Pankaj R on 14-11-17 for enterprise logo
				dashboardPanel.setWidth(Window.getClientWidth() + "px");
				dashboardPanel.setHeight(Window.getClientHeight() + "px");
				dashboardPanel.getElement().getStyle().setOverflow(Overflow.AUTO);
				DOM.getElementById( "loading" ).removeFromParent();
				loadProfileFromServlet(E12Constants.userID);
				Window.addResizeHandler(new ResizeHandler() {

					@Override
					public void onResize(ResizeEvent event) {

						dashboardPanel.setWidth(Window.getClientWidth() + "px");
						dashboardPanel.setHeight(Window.getClientHeight() + "px");
						if(dashboardPanel.getWidget(0) != null)
						{
							dashboardPanel.getWidget(0).setHeight(Window.getClientHeight() + "px");
							dashboardPanel.getWidget(0).setWidth(Window.getClientWidth() + "px");
							((CustomTabLayoutWidget)dashboardPanel.getWidget(0)).selectTab(0);
						}
					}
				});
			}
			catch(Exception e)
			{
				Window.alert("Error : [" + e.getMessage() + "]");
			}
			return dashboardPanel;
		}

		//Ended By Mahesh Patidar
		// Added by Dnyaneshwar chavan on 26-Apr-14 [ Hide the E12Intro popup panel] Start
		public void openTransaction( E12TransInfoObj e12TransInfoObj )
		{
			try
			{
				E12CommonUtils.printOnConsole( "BaseE12 openTransaction" );
				// added by mahesh saggam on 16-OCT-19 [to add poppanel which slides in and out the menupanel on maximize] Start
				if(E12AltHeader.homePopupPnl.getElement() != null && E12SearchBar.hideMenuBtn.isDown() && E12AltHeader.mainVPnl.getWidgetCount() == 2)
				{
					E12AltHeader.homePopupPnl.getElement().setAttribute("style", "width: 270px");
					if(DOM.getElementById("mainMenusFlowPnl") != null)
					{
						DOM.getElementById("mainMenusFlowPnl").setAttribute("style", "width: 270px");
					}
				}
				// added by mahesh saggam on 16-OCT-19 [to add poppanel which slides in and out the menupanel on maximize] End
				 // added by mahesh saggam on 10-OCT-19 [to add poppanel which slides in and out the menupanel on maximize]
				E12AltHeader.homePopupPnl.hide(); 
				if( e12TransInfoObj != null )
				{
					//Changed By Suraj on 14-12-2016 [For menu restriction]Start
					if( !"true".equalsIgnoreCase( e12TransInfoObj.getRestrictValue() ) )
					{
						String title = e12TransInfoObj.getTitle();
						String menuIdStr = e12TransInfoObj.getId().trim();//Like SFA.1.0.0.0.0
						String tranObjName = e12TransInfoObj.getObjName();
						E12Constants.objName = e12TransInfoObj.getObjName();
						E12Global.getInstance().addObjName(E12Constants.objName);
						E12Constants.objTitle = e12TransInfoObj.getTitle();
						E12Global.getInstance().addObjTitle(E12Constants.objTitle);
						E12Global.getInstance().getObjFormInfo().put(E12Constants.objTitle, E12Constants.objName);
						//Added by shrutika on 18-01-19 [Start] for getting objname on click of close tab for remove user activities.
						String menuIdStrkey = menuIdStr.replace(".", "_");
						E12Global.getObjFormInfo().put(menuIdStrkey, E12Constants.objName);
						//Added by shrutika on 18-01-19 [End] for getting objname on click of close tab for remove user activities.
						//Added By Pratheek on 28/6/17[if menuId comes blank and pass the id to set in TransInfoObj]-Start
						if("".equalsIgnoreCase(menuIdStr) )
						{
							menuIdStr = getMenuIdInTree(tranObjName,e12TransInfoObj.getObjType());
							e12TransInfoObj.setId(menuIdStr);
						}
						//Added By Pratheek on 28/6/17[if menuId comes blank and pass the id to set in TransInfoObj]-End
						E12CommonUtils.printOnConsole("Setting toSelectItemID as [" + menuIdStr + "] On click of [" + title+"] tranObjName ["+tranObjName+"] objType ["+e12TransInfoObj.getObjType()+"]");
						//Added By Pankaj T on 04-05-18 for disable feed on click of action - Start
						E12Global.getInstance().getPanelLabelMap().clear();
						//Added By Pankaj T on 04-05-18 for disable feed on click of action - End
						BaseE12.e12MenuPanel.e12TransMenu.toSelectItemID = menuIdStr;
						//Added By Ajinkya Gopalkar on 2-DEC-15[for maximize screen option on menu selection]
						String defValueOption = e12TransInfoObj.getDefValueOpt();
						if(defValueOption !=null && "1".equalsIgnoreCase( defValueOption ))
						{
							BaseE12.invokeAction("maximize");
						}
						//Suraj temp added to test
						E12CommonUtils.getInstance().setE12TransInfoObj(e12TransInfoObj);

						E12Constants.objName = e12TransInfoObj.getObjName();
						E12Constants.objTitle = e12TransInfoObj.getTitle();
						E12Constants.objType = e12TransInfoObj.getObjType();

						//Added by shrutika on 20-07-17 [Start] for second time dcr is not open on Call Report Status menu issue
						if("true".equalsIgnoreCase(isDcrOpen))
						{
							E12Global.getInstance().setMyCircleClick(true);
						}
						else
						{
							E12Global.getInstance().setMyCircleClick(false);
						}
						//Added by shrutika on 20-07-17 [End] for second time dcr is not open on Call Report Status menu issue
						/**
						 * Depending upon following object type it will generate random ID.
						 */
						//Changed By Mahesh Patidar on 23-OCT-13 [to add Z objType for GWT process Window]
//					if( e12TransInfoObj.getObjType().equalsIgnoreCase( "I" ) || e12TransInfoObj.getObjType().equalsIgnoreCase( "L" ) || e12TransInfoObj.getObjType().equals( "W" ) )
						//Changed By Prasad on 15/06/15 [to add E (for Document Upload with Transaction) and A (for SSC transaction)]
						//if( e12TransInfoObj.getObjType().equalsIgnoreCase( "I" ) || e12TransInfoObj.getObjType().equalsIgnoreCase( "L" ) || e12TransInfoObj.getObjType().equals( "W" ) || e12TransInfoObj.getObjType().equals( "Z" ) || e12TransInfoObj.equals("R") || e12TransInfoObj.equals("C") || e12TransInfoObj.equals("D"))
						//Changed By Prasad on 08/09/15 [to add S (for Survey)]
						//if( e12TransInfoObj.getObjType().equalsIgnoreCase( "I" ) || e12TransInfoObj.getObjType().equalsIgnoreCase( "L" ) || e12TransInfoObj.getObjType().equals( "W" ) || e12TransInfoObj.getObjType().equals( "Z" ) || e12TransInfoObj.equals("R") || e12TransInfoObj.equals("C") || e12TransInfoObj.equals("D") || e12TransInfoObj.getObjType().equals( "A" ) || e12TransInfoObj.equals("E") || e12TransInfoObj.getObjType().equals("M"))
						//Changed by Chetan Mahajan on 08-09-2015 [For Workflow pending transaction Req id : W15FSUN005]
						//if( e12TransInfoObj.getObjType().equalsIgnoreCase( "I" ) || e12TransInfoObj.getObjType().equalsIgnoreCase( "L" ) || e12TransInfoObj.getObjType().equals( "W" ) || e12TransInfoObj.getObjType().equals( "Z" ) || e12TransInfoObj.equals("R") || e12TransInfoObj.equals("C") || e12TransInfoObj.equals("D") || e12TransInfoObj.getObjType().equals( "A" ) || e12TransInfoObj.equals("E") || e12TransInfoObj.getObjType().equals("M") || e12TransInfoObj.getObjType().equals("S"))
						//Added by shrutika on 09-12-19 for editor id not getting updated in case of process screen.(so that casting issue occur on server side in RIAwizardHandlerServlet.)
						//Added By Shrutika N. on 16-12-2020 added new obj_type j to open angular component for incentive process to show a processid according to win_name
						//if( e12TransInfoObj.getObjType().equalsIgnoreCase( "I" ) || e12TransInfoObj.getObjType().equalsIgnoreCase( "L" ) || e12TransInfoObj.getObjType().equals( "W" ) || e12TransInfoObj.getObjType().equals( "Z" ) || e12TransInfoObj.equals("R") || e12TransInfoObj.equals("C") || e12TransInfoObj.equals("D") || e12TransInfoObj.getObjType().equals( "A" ) || e12TransInfoObj.equals("E") || e12TransInfoObj.getObjType().equals("M") || e12TransInfoObj.getObjType().equals("S")  || e12TransInfoObj.getObjType().equals("H") || e12TransInfoObj.getObjType().equalsIgnoreCase( "P" ) )
						if( e12TransInfoObj.getObjType().equalsIgnoreCase( "I" ) || e12TransInfoObj.getObjType().equalsIgnoreCase( "L" ) || e12TransInfoObj.getObjType().equals( "W" ) || e12TransInfoObj.getObjType().equals( "Z" ) || e12TransInfoObj.equals("R") || e12TransInfoObj.equals("C") || e12TransInfoObj.equals("D") || e12TransInfoObj.getObjType().equals( "A" ) || e12TransInfoObj.equals("E") || e12TransInfoObj.getObjType().equals("M") || e12TransInfoObj.getObjType().equals("S")  || e12TransInfoObj.getObjType().equals("H") || e12TransInfoObj.getObjType().equalsIgnoreCase( "P" )|| e12TransInfoObj.getObjType().equalsIgnoreCase( "J" ) || e12TransInfoObj.getObjType().equalsIgnoreCase( "V" ) )
						{
							String mapId = E12Constants.userID + menuIdStr;
							String randomID = E12Constants.userID + generateRandomNo();

							instanceIdStr = null;
							instanceIdStr = randomID;
							E12CommonUtils.printOnConsole( "openTransaction tabsMap["+tabsMap.toString()+"]" );
							if( ! tabsMap.containsKey( mapId ) )
							{
								tabsMap.put( mapId, randomID );
							}
							else
							{
								int e12TabCount = e12TransBrow.e12TabPanel.getWidgetCount();
								int tabToRemove = -1;
								//Added by Prasad on 03/05/18 [open existing selected menu's]
								boolean flag = false;
								for ( int i = 1; i < e12TabCount; i++ )
								{
									final VerticalPanel e12PnlGenWidget = ( VerticalPanel ) ( BaseE12.e12TransBrow.e12TabPanel.getWidget( i ) );
									if ( e12PnlGenWidget.getWidgetCount() >= 2 )
									{
										TextBox tbID = ( TextBox ) e12PnlGenWidget.getWidget( 1 );
										if( menuIdStr.equalsIgnoreCase( tbID.getText() ) )
										{
											tabToRemove = i;
											//Added by Prasad on 03/05/18 [open existing selected menu's]
											e12TransBrow.e12TabPanel.selectTab(tabToRemove);
											flag = true;
											//Added by Sagar M. on 02/11/18 [Removing and adding local js each time on menu click]Start
											E12CommonUtils.printOnConsole("BaseE12 inside remove js file objname ["+e12TransInfoObj.getObjName()+"]");
											E12CommonUtils.getInstance().removeJSFile(e12TransInfoObj.getObjName(), "js");
										    E12CommonUtils.printOnConsole("BaseE12 inside include jsfileName------"+e12TransInfoObj.getObjName());
											String jsFilePath = E12Global.getHostUrl() + "/ibase/webitm/js/"+e12TransInfoObj.getObjName()+".js";
											E12CommonUtils.getInstance().includeJSFile(jsFilePath);
											//Added by Sagar M. on 02/11/18 [Removing and adding local js each time on menu click]End
											break;
										}
									}
								}
								//Changes By Prajyot on 24-08-2011 [ To restrict user from opening more than 12 Tabs ] Starts
								//Added by Prasadon 03/05/18 [open existing selected menu's] START
								//e12TransBrow.e12TabPanel.selectTab(tabToRemove);
								if( flag == true )
								{
									return;
								}
								//Added by Prasad on 03/05/18 [open existing selected menu's] END
							}
						}

						String objType = e12TransInfoObj.getObjType();
						isWidgetPresent = false;
						/**
						 * It will check the object type. Depending upon the object type it will called respective panel.
						 */
						//Changed By Mahesh Patidar on 23-OCT-13 [to add Z objType for GWT process Window]
//					if( objType.equals("G") || objType.equals("T") || objType.equals("P") ||  objType.equals("W") || objType.equals("I") || objType.equals("L") || objType.equals("F"))//Comment By Umakanta On 12/FEB/2015
						//Changed By Prasad on 15/06/15 [to add E (for Document Upload with Transaction) and A (for SSC transaction)]
						//if( objType.equals("G") || objType.equals("T") || objType.equals("P") ||  objType.equals("W") || objType.equals("I") || objType.equals("L") || objType.equals("F") || objType.equals("Z") || objType.equals("R") || objType.equals("C") || objType.equals("D"))
						//Changed By Prasad on 08/09/15 [to add S (for Survey)]
						//if( objType.equals("G") || objType.equals("T") || objType.equals("P") ||  objType.equals("W") || objType.equals("I") || objType.equals("L") || objType.equals("F") || objType.equals("Z") || objType.equals("R") || objType.equals("C") || objType.equals("D") || objType.equals("A") || objType.equals("E") || objType.equals("M") )
						//Changed by Chetan Mahajan on 08-09-2015 [For Workflow pending transaction Req id : W15FSUN005]
						//if( objType.equals("G") || objType.equals("T") || objType.equals("P") ||  objType.equals("W") || objType.equals("I") || objType.equals("L") || objType.equals("F") || objType.equals("Z") || objType.equals("R") || objType.equals("C") || objType.equals("D") || objType.equals("A") || objType.equals("E") || objType.equals("M") || objType.equals("S") )
						//if( objType.equals("G") || objType.equals("T") || objType.equals("P") ||  objType.equals("W") || objType.equals("I") || objType.equals("L") || objType.equals("F") || objType.equals("Z") || objType.equals("R") || objType.equals("C") || objType.equals("D") || objType.equals("A") || objType.equals("E") || objType.equals("M") || objType.equals("S") || objType.equals("H"))
						//Added By Shrutika N. on 16-12-2020 added new obj_type j to open angular component for incentive process to show a processid according to win_name
						if( objType.equals("G") || objType.equals("T") || objType.equals("P") ||  objType.equals("W") || objType.equals("I") || objType.equals("L") || objType.equals("F") || objType.equals("Z") || objType.equals("R") || objType.equals("C") || objType.equals("D") || objType.equals("A") || objType.equals("E") || objType.equals("M") || objType.equals("S") || objType.equals("H") || objType.equals("J") || objType.equals("V"))
						{
							int e12TabCount = e12TransBrow.e12TabPanel.getWidgetCount();
							//Changes By Prajyot on 24-08-2011 [ To restrict user from opening more than 12 Tabs ] Starts
							/**
							 * Check for 12 tab open in RIALite.
							 * If 12 tab is open it cannot allow to open new tab.
							 */
							if( e12TabCount > 12 )
							{
								boolean flag = false;
								for ( int i = 1; i < e12TabCount; i++ )
								{
									final VerticalPanel e12PnlGenWidget = ( VerticalPanel ) ( BaseE12.e12TransBrow.e12TabPanel.getWidget( i ) );
									if ( e12PnlGenWidget.getWidgetCount() >= 2  )
									{
										TextBox tbID = ( TextBox ) e12PnlGenWidget.getWidget( 1 );
										if( menuIdStr.equalsIgnoreCase( tbID.getText() ) )
										{
											e12TransBrow.e12TabPanel.selectTab(i);
											flag = true;
											//Added by Sagar M. on 02/11/18 [Removing and adding local js each time on menu click]Start
											E12CommonUtils.printOnConsole("BaseE12 inside remove js file objname ["+e12TransInfoObj.getObjName()+"]");
											E12CommonUtils.getInstance().removeJSFile(e12TransInfoObj.getObjName(), "js");
										    E12CommonUtils.printOnConsole("BaseE12 inside include jsfileName------"+e12TransInfoObj.getObjName());
											String jsFilePath = E12Global.getHostUrl() + "/ibase/webitm/js/"+e12TransInfoObj.getObjName()+".js";
											E12CommonUtils.getInstance().includeJSFile(jsFilePath);
											//Added by Sagar M. on 02/11/18 [Removing and adding local js each time on menu click]End
										}
									}
								}
								if( flag == true )
								{
									return;
								}
								else
								{
									//Window.alert( moreThan12 );
									// Added by Reema on 28-Oct-14 [Remove earlieast tab if TabCount exceed than 12 as per Kandarp sir]
									int lastTabCount = e12TabCount - 1;
									String lastTab = e12TransBrow.e12TabPanel.getTabTitle(lastTabCount);
									E12CommonUtils.printOnConsole("LastTab: "+lastTab);
									closeTab();
							        BaseE12.e12TransBrow.e12TabPanel.remove( lastTabCount );
							        E12CommonUtils.printOnConsole("lastTabCount "+lastTabCount);
							        for ( int i = 1; i < lastTabCount; i++ )
									{
							        	//Changed by Sandeep S. on 23-02-17 Start
										/*final VerticalPanel e12PnlGenWidget = ( VerticalPanel ) ( BaseE12.e12TransBrow.e12TabPanel.getWidget( i ) );
										if ( e12PnlGenWidget.getWidgetCount() >= 2  )
										{
											TextBox tbID = ( TextBox ) e12PnlGenWidget.getWidget( 1 );
											if( menuIdStr.equalsIgnoreCase( tbID.getText() ) )
											{
												e12TransBrow.e12TabPanel.selectTab(i);
												isWidgetPresent = true;
											}
										}*/

							        	final VerticalPanel e12PnlGenWidget = ( VerticalPanel ) ( BaseE12.e12TransBrow.e12TabPanel.getWidget( i ) );
										HorizontalPanel horzPanel = new HorizontalPanel();
										VerticalPanel newE12PnlGenWidget = new VerticalPanel();
										//Changes made by Pratheek on 20-08-18[on second time when click on menu server call was getting call to load homepage ]-Start
										if( e12PnlGenWidget.getWidgetCount() > 0 )
										//Changes made by Pratheek on 20-08-18[on second time when click on menu server call was getting call to load homepage ]-End
										{
											if( e12PnlGenWidget.getWidget(0) instanceof HorizontalPanel )
											{
												horzPanel = (HorizontalPanel) e12PnlGenWidget.getWidget(0);
												if( horzPanel.getWidget(0) instanceof VerticalPanel )
												{
													newE12PnlGenWidget = (VerticalPanel) horzPanel.getWidget(0);
												}
											}
										}
										if( newE12PnlGenWidget != null && newE12PnlGenWidget.getWidgetCount() > 1 )
										{
											if ( newE12PnlGenWidget.getWidgetCount() >= 2  )
											{
												TextBox tbID = ( TextBox ) newE12PnlGenWidget.getWidget( 1 );
												if( menuIdStr.equalsIgnoreCase( tbID.getText() ) )
												{
													//Added by Shrutika on 17-07-17 [Start] for Call Report Status menu issue
													if("true".equalsIgnoreCase( isDcrOpen ))
													{
														e12TransBrow.e12TabPanel.remove(i);
														isWidgetPresent = false;
														isDcrOpen = "false";
													}
													else
													{
														e12TransBrow.e12TabPanel.selectTab(i);
														isWidgetPresent = true;
														//Added by Sagar M. on 02/11/18 [Removing and adding local js each time on menu click]Start
														E12CommonUtils.printOnConsole("BaseE12 inside remove js file objname ["+e12TransInfoObj.getObjName()+"]");
														E12CommonUtils.getInstance().removeJSFile(e12TransInfoObj.getObjName(), "js");
													    E12CommonUtils.printOnConsole("BaseE12 inside include jsfileName------"+e12TransInfoObj.getObjName());
														String jsFilePath = E12Global.getHostUrl() + "/ibase/webitm/js/"+e12TransInfoObj.getObjName()+".js";
														E12CommonUtils.getInstance().includeJSFile(jsFilePath);
														//Added by Sagar M. on 02/11/18 [Removing and adding local js each time on menu click]End
													}
													//Added by shrutika on 17-07-17 [End] for Call Report Status menu issue
//												e12TransBrow.e12TabPanel.selectTab(i);
//												isWidgetPresent = true;
												}
											}
										}
										//Changed by Sandeep S. on 23-02-17 End
									}

							        E12CommonUtils.printOnConsole("Inside BassE12 1263 isWidgetPresent!!!!!!"+isWidgetPresent +"]");
									if( isWidgetPresent == false )
									{
										//Added by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user] START
										int tabIndex = 1;
										if ( e12TabCount == 0 )
										{
											tabIndex = 0;
										}
										//Added by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user] END
										if( objType.equals( "W" ) || objType.equals( "Z" ) )
										{
											//changed by parikshit on 29/12/16 [to add side panel] start
											/*EntryWrapper entry = new EntryWrapper();
											entry.setComment( e12TransInfoObj.getComment() );
											entry.setIcon( e12TransInfoObj.getIcon() );
											entry.setId( e12TransInfoObj.getId() );
											entry.setObjName( e12TransInfoObj.getObjName() );
											entry.setObjType( e12TransInfoObj.getObjType() );
											entry.setTitle( e12TransInfoObj.getTitle() );

											E12Wizard e12Wizard = new E12Wizard(entry, instanceIdStr, e12TransInfoObj.getId(), callerInterface);
											VerticalPanel vPanel  = e12Wizard.getWizardPageRootPanel();
											vPanel.setStyleName("tabContentPanel");
											e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, title);
											e12TransBrow.e12TabPanel.selectTab( 1 );*/

											E12SidePanelContainers e12SidePanelContainers = new E12SidePanelContainers(e12TransInfoObj, instanceIdStr, callerInterface, null);
											VerticalPanel vPanel = (VerticalPanel) e12SidePanelContainers.getWidget();
											vPanel.setStyleName("tabContentPanel");
											//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
											e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), tabIndex, title);
											//changed by parikshit on 29/12/16 [to add side panel] end
											e12TransBrow.e12TabPanel.selectTab( tabIndex );
										}
										else if( objType.equals("T") )
										{
											//Added by shrutika on 18-01-19 [Start] for getting first widget on click of close tab for remove user activities.
											TextBox tabIdTxtBx = new TextBox();
											tabIdTxtBx.setText(menuIdStr);
											tabIdTxtBx.setVisible( false );
											tabIdTxtBx.setHeight("0px");
											//Added by shrutika on 18-01-19 [End] for getting first widget on click of close tab for remove user activities.
											//changed by parikshit on 29/12/16 [to add side panel] start
											/*E12HomePage e12HomePage = new E12HomePage();
											VerticalPanel vPanel =  e12HomePage.createE12HomePage( e12TransInfoObj, menuIdStr );*/
											E12SidePanelContainers e12SidePanelContainers = new E12SidePanelContainers(e12TransInfoObj, instanceIdStr, callerInterface, null);
											VerticalPanel vPanel =  e12SidePanelContainers.getWidget();
											vPanel.setStyleName("tabContentPanel");

											//Added by shrutika on 18-01-19 [Start] for getting first widget on click of close tab for remove user activities.
											vPanel.add(tabIdTxtBx);
											//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
											e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), tabIndex, e12SidePanelContainers.e12HomePage, title, "");
											//changed by parikshit on 29/12/16 [to add side panel] end
											e12TransBrow.e12TabPanel.selectTab(tabIndex);
										}
										//Added By UMAKANTA On 12/FEB/2015 [ For display report through Browser Interface ] Start
										else if( objType.equals("R") )
										{
											//Changed by Prasad on 02/11/17 [implementation of side panel for report] START
											E12SidePanelContainers e12SidePanelContainers = new E12SidePanelContainers(e12TransInfoObj, instanceIdStr, callerInterface, null);
											//E12Report e12Report = new E12Report( e12TransInfoObj );
											TextBox tabIdTxtBx = new TextBox();
											tabIdTxtBx.setText(menuIdStr);
											tabIdTxtBx.setVisible( false );
											tabIdTxtBx.setHeight("0px");

											//VerticalPanel vTabPanel =  new VerticalPanel();
											VerticalPanel vTabPanel =  e12SidePanelContainers.getWidget();
											//vTabPanel.add(e12Report);
											//Added by Prasad on 02/11/17 [implementation of side panel for report] END
											vTabPanel.add( tabIdTxtBx );
											//vTabPanel.setStylePrimaryName( "mainPage-Container" );
											// added mahesh saggam on 10-OCT-19 [to add poppanel which slides in and out the menupanel on maximize]
											vTabPanel.setStyleName("reportTabContentPanel");
											e12TransBrow.e12TabPanel.insert( vTabPanel, getTabWidget( vTabPanel, title ), 1);
											e12TransBrow.e12TabPanel.selectTab(1);
										}//Added By UMAKANTA On 12/FEB/2015 [ For display report through Browser Interface ] End
										else if( objType.equals("G") )
										{
											VerticalPanel vPanel =  new E12TransPanelGenerator().createE12TransPanel( e12TransInfoObj );
											vPanel.setStyleName("tabContentPanel");
											//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
											e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), tabIndex, title);
											e12TransBrow.e12TabPanel.selectTab(tabIndex);
										}
										//Added by Pratheek on 25-05-18[to call the process screen same as wizard]-Start
										else if( objType.equals("P") )
										{
											if(instanceIdStr == null)
											{
												instanceIdStr = E12Constants.userID + generateRandomNo();;
											}
//										VerticalPanel vPanel = ( VerticalPanel ) ( new E12PanelGenerator().createE12TransPanel( e12TransBrow, e12TransInfoObj, instanceIdStr ) );
											//e12TransBrow.e12TabPanel.insert( vPanel, title, 1 );
											E12SidePanelContainers e12SidePanelContainers = new E12SidePanelContainers(e12TransInfoObj, instanceIdStr, callerInterface, null);
											E12CommonUtils.printOnConsole("menuIdStr 1663!!!!!{"+menuIdStr+"}");
											VerticalPanel vPanel =  e12SidePanelContainers.getWidget();

											vPanel.setStylePrimaryName( "tabContentPanel" );
											//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
											e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), tabIndex, title);
											e12TransBrow.e12TabPanel.selectTab( 1 );
											if(E12Global.isGalaxy())
											{
												((Element) vPanel.getElement().getFirstChild().getChild(1)).setAttribute("style", "height: 0px;");
											}
										}
										//Added by Pratheek on 25-05-18[to call the process screen same as wizard]-End
										//Added By Prasad on 15/06/15 [to add E (for Document Upload with Transaction)] START
										else if( objType.equals("E") )
										{
											VerticalPanel vPanel = null;
											if ( e12TransInfoObj.getObjName().indexOf("/") != -1 )
											{
												vPanel = ( VerticalPanel ) ( new E12PanelGenerator().createE12TransPanel( e12TransInfoObj, instanceIdStr ) );
												//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
												e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), tabIndex, title);
											}
											else
											{
												//Changed by Pankaj P on 24/02/2021 [changed as per new changes for homepage] START
												/*E12HomePage e12HomePage = new E12HomePage();
												vPanel =  e12HomePage.createE12HomePage( e12TransInfoObj, menuIdStr );
												e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, e12HomePage, title, "");*/
												
												TextBox tabIdTxtBx = new TextBox();
												tabIdTxtBx.setText(menuIdStr);
												tabIdTxtBx.setVisible( false );
												tabIdTxtBx.setHeight("0px");
												
												E12SidePanelContainers e12SidePanelContainers = new E12SidePanelContainers(e12TransInfoObj, instanceIdStr, callerInterface, null);
												vPanel = e12SidePanelContainers.getWidget();
												vPanel.setStyleName("tabContentPanel");

												vPanel.add(tabIdTxtBx);
												//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
												e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), tabIndex, e12SidePanelContainers.e12HomePage, title, "");
												//Changed by Pankaj P on 24/02/2021 [changed as per new changes for homepage] END
											}
											vPanel.setStyleName("tabContentPanel");
											//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
											e12TransBrow.e12TabPanel.selectTab(tabIndex);
										}
										//Added By Prasad on 15/06/15 [to add E (for Document Upload with Transaction)] END
										else if( objType.equals("C") || objType.equals("M"))
										{
											if(instanceIdStr == null)
											{
												instanceIdStr = E12Constants.userID + generateRandomNo();;
											}
											//Changed By Suraj on 19-01-2017 [To set objName on tab selection]Start
											E12PanelGenerator e12PanelGenerator = new E12PanelGenerator();
											VerticalPanel vPanel = ( VerticalPanel ) ( e12PanelGenerator.createE12TransPanel( e12TransInfoObj, instanceIdStr ) );
											vPanel.setStylePrimaryName( "tabContentPanel" );
											//e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, title);
											//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
											e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), tabIndex, e12PanelGenerator, title, menuIdStr.replace(".", "_"));
											//Changed By Suraj on 19-01-2017 [To set objName on tab selection]End
											e12TransBrow.e12TabPanel.selectTab(tabIndex);
											((Element) vPanel.getElement().getFirstChild().getChild(1)).setAttribute("style", "height: 0px;");
										}
										//Added by Savita Yadav on 18-05-2015 [For Bulk delete attachment] - Start
										else if( objType.equals("D") )
										{
											VerticalPanel vPanel =  new E12BulkDelete().createSearchPanel(e12TransInfoObj);
											vPanel.setStyleName("tabContentPanel");
											//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
											e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), tabIndex, title);
											e12TransBrow.e12TabPanel.selectTab(tabIndex);
										}
										//Added by Savita Yadav on 18-05-2015 [For Bulk delete attachment] - End
										//Added By Prashant Chavan  on 26-Aug-15 [ For Survey] START
										else if( objType.equals("S") )
										{
											E12Survey e12Survey = new E12Survey( e12TransInfoObj );
											VerticalPanel vTabPanel =  new VerticalPanel();
											vTabPanel.add(e12Survey);
											vTabPanel.setStylePrimaryName( "mainPage-Container" );
											//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
											e12TransBrow.e12TabPanel.insert( vTabPanel, getTabWidget( vTabPanel, title ), tabIndex);
											e12TransBrow.e12TabPanel.selectTab(tabIndex);
										}
										//Added By Prashant Chavan  on 26-Aug-15 [ For Survey] END
										//Added by Chetan Mahajan on 08-09-2015 [For Workflow pending transaction Req id : W15FSUN005] - Start
										else if( objType.equals("H") )
										{
											WFPRCDataView e12workflowstatus = new WFPRCDataView(e12TransInfoObj);
											VerticalPanel vTabPanel = new VerticalPanel();
											vTabPanel.add(e12workflowstatus);
											vTabPanel.setStylePrimaryName( "mainPage-Container" );
											//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
											e12TransBrow.e12TabPanel.insert( vTabPanel, getTabWidget( vTabPanel, title ), tabIndex);
											e12TransBrow.e12TabPanel.selectTab(tabIndex);
										}
										//Added by Chetan Mahajan on 08-09-2015 [For Workflow pending transaction Req id : W15FSUN005] - End
										//Added By Prajyot Rumde on 19-JUN-18 [ For Dashboard Load From Menu for objType A] START
										else if( objType.equals("A") )
										{
											// Changed  by Pravin K on 27-NOV-19 [For message notification] START
											if("message_comp".equalsIgnoreCase( E12Constants.objName) ) 
											{
												
												E12CommonUtils.printOnConsole("0: Notification component ");
												
												VerticalPanel notificationScrPanel = new VerticalPanel();
												
												NotificationPanel notificationPanel = new NotificationPanel();
												notificationScrPanel.add(notificationPanel.getAddUI());
												notificationScrPanel.setStyleName("notificatinScrollPanel");
												
												notificationScrPanel.getElement().setAttribute("data-tab-id", menuIdStr);
												//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
												e12TransBrow.e12TabPanel.insert(notificationScrPanel, getTabWidget( notificationScrPanel, title ), tabIndex);
												e12TransBrow.e12TabPanel.selectTab(tabIndex);
											}
											else
											{
												E12ANGReport angReport = new E12ANGReport(e12TransInfoObj);
												VerticalPanel vTabPanel =  new VerticalPanel();
												E12CommonUtils.printOnConsole("objType and for A objType angReport IN !!!!!{"+objType+"}["+ angReport + "]");
												vTabPanel.add(angReport);
												
												TextBox tbID = new TextBox();
												tbID.setText( e12TransInfoObj.getId() );
												tbID.setVisible( false );
												vTabPanel.add( tbID );
												
												vTabPanel.setStylePrimaryName( "mainPage-Container" );
												//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
												e12TransBrow.e12TabPanel.insert( vTabPanel, getTabWidget( vTabPanel, title ), tabIndex);
												e12TransBrow.e12TabPanel.selectTab(tabIndex);
											}
											// Changed  by Pravin K on 27-NOV-19 [For message notification] END
										}
										//Added By Prajyot Rumde on 19-JUN-18 [ For Dashboard Load From Menu for objType A] END
										//Added By Shrutika N. on 16-12-2020 added new obj_type j to open angular component for incentive process to show a processid according to win_name - start
										else if( objType.equals("J") ) 
										{
											E12CommonUtils.printOnConsole("inside objType j.............1765");
											
											VerticalPanel vTabPanel =  new VerticalPanel();
											final String targetId = "generalized_process";
											
											String objName = e12TransInfoObj.getObjName();
											E12CommonUtils.printOnConsole("inside objType j.............1777"+objName);
											
											final JSONObject configData = new JSONObject();
											configData.put("componentName", new JSONString(targetId));
											configData.put("targetId", new JSONString(targetId));
											configData.put("OBJ_NAME", new JSONString(objName));
											
											E12CommonUtils.printOnConsole("inside objType j.............1784"+configData.toString());
											
											E12AngularComponent e12AngularComponent = new E12AngularComponent( targetId , configData.toString() );
											vTabPanel.add(e12AngularComponent);
											
											TextBox tbID = new TextBox();
											tbID.setText( e12TransInfoObj.getId() );
											tbID.setVisible( false );
											vTabPanel.add( tbID );
											vTabPanel.setStylePrimaryName( "mainPage-Container" );
											//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
											e12TransBrow.e12TabPanel.insert( vTabPanel, getTabWidget( vTabPanel, title ), tabIndex);
											e12TransBrow.e12TabPanel.selectTab(tabIndex);
										}
										//Added By Shrutika N. on 16-12-2020 added new obj_type j to open angular component for incentive process to show a processid according to win_name - end
										//Added By nikhil on 23-02-2022 added new obj_type v to open angular component for shared visual to show a processid according to win_name [start]
										else if( objType.equals("V") ) 
										{
											E12CommonUtils.printOnConsole("inside objType v.............1933");
											
											VerticalPanel vTabPanel =  new VerticalPanel();
											final String targetId = "dash_def";
											
											String objName = e12TransInfoObj.getObjName();
											E12CommonUtils.printOnConsole("inside objType v.............1939"+objName);
											
											final JSONObject configData = new JSONObject();
											configData.put("componentName", new JSONString(targetId));
											configData.put("targetId", new JSONString(targetId));
											configData.put("OBJ_NAME", new JSONString(objName));
											
											E12CommonUtils.printOnConsole("inside objType v.............1946"+configData.toString());
											
											E12AngularComponent e12AngularComponent = new E12AngularComponent( targetId , configData.toString() );
											vTabPanel.add(e12AngularComponent);
											
											TextBox tbID = new TextBox();
											tbID.setText( e12TransInfoObj.getId() );
											tbID.setVisible( false );
											vTabPanel.add( tbID );
											vTabPanel.setStylePrimaryName( "mainPage-Container" );
											e12TransBrow.e12TabPanel.insert( vTabPanel, getTabWidget( vTabPanel, title ), 1);
											e12TransBrow.e12TabPanel.selectTab(1);
										}
										//Added By nikhil on 23-02-2022 added new obj_type v to open angular component for shared visual to show a processid according to win_name [End]
										else
										{
											if(instanceIdStr == null)
											{
												instanceIdStr = E12Constants.userID + generateRandomNo();;
											}
											VerticalPanel vPanel = ( VerticalPanel ) ( new E12PanelGenerator().createE12TransPanel(e12TransInfoObj, instanceIdStr ) );
											vPanel.setStyleName("tabContentPanel");
											//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
											e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), tabIndex, title);
											e12TransBrow.e12TabPanel.selectTab( tabIndex );
										}
									}

//								Window.alert( moreThan12 );
									// Added by Reema on 28-Oct-14 [Remove earlieast tab if TabCount exceed than 12 as per Kandarp sir]-End
								}
							}

							/**
							 * If tab is already present into tabpanel then it remove first & create it on first tab position.
							 * Otherwise create new tab on first position.
							 */
							else
							{
								//Added by shrutika on 18-01-19 [Start] for getting objname on click of close tab for remove user activities.
								String mapId = E12Constants.userID + menuIdStr + "_" + "OBJ_NAME";
								if( ! tabsMap.containsKey( mapId ) )
								{
									E12CommonUtils.printOnConsole("inside opentransaction.....1668");
									tabsMap.put( mapId, E12Constants.objName );
								}
								//Added by shrutika on 18-01-19 [End] for getting objname on click of close tab for remove user activities.
								E12CommonUtils.printOnConsole("BaseE12 : 1399 e12TabCount ["+e12TabCount+"]");
								for ( int i = 1; i < e12TabCount; i++ )
								{
									//Changed by Sandeep S. on 23-02-17 Start
									final VerticalPanel e12PnlGenWidget = ( VerticalPanel ) ( BaseE12.e12TransBrow.e12TabPanel.getWidget( i ) );
									HorizontalPanel horzPanel = new HorizontalPanel();
									VerticalPanel newE12PnlGenWidget = new VerticalPanel();
									//Changes made by Pratheek on 20-08-18[on second time when click on menu server call was getting call to load homepage ]-Start
									if( e12PnlGenWidget.getWidgetCount() > 0 )
									//Changes made by Pratheek on 20-08-18[on second time when click on menu server call was getting call to load homepage ]-End
									{
										if( e12PnlGenWidget.getWidget(0) instanceof HorizontalPanel )
										{
											horzPanel = (HorizontalPanel) e12PnlGenWidget.getWidget(0);
											if( horzPanel.getWidget(0) instanceof VerticalPanel )
											{
												newE12PnlGenWidget = (VerticalPanel) horzPanel.getWidget(0);
											}
										}
									}
									//Added By Suraj on 28-feb-2017 [To handle multiple click on Calendar Menu]Start
									//VerticalPanel vertPanel = new VerticalPanel();
									int calWdCount = e12PnlGenWidget.getWidgetCount();
									E12CommonUtils.printOnConsole("BaseE12 : 1419 calWdCount ["+calWdCount+"] current objType ["+objType+"] menuIdStr ["+menuIdStr+"]");
									//For multiple click handle
									if( calWdCount > 1 && ( objType.equals( "C" ) || objType.equals( "M" ) || objType.equals( "I" ) ) )
									{
										//Changed by Prasad on 03/05/18 [open existing selected menu's] START
										TextBox tbID = null;
										if( e12PnlGenWidget.getWidget( 0 ) instanceof TextBox )
										{
											tbID = ( TextBox ) e12PnlGenWidget.getWidget( 1 );
										}
										if( e12PnlGenWidget.getWidget( 1 ) instanceof TextBox )
										{
											E12CommonUtils.printOnConsole("BaseE12 : 1431 second");
											tbID = ( TextBox ) e12PnlGenWidget.getWidget( 1 );
										}
										E12CommonUtils.printOnConsole("1433 : menuId ["+menuIdStr+"] tabId ["+tbID.getText()+"]");
										if( menuIdStr.equalsIgnoreCase( tbID.getText() ) )
										{
											e12TransBrow.e12TabPanel.selectTab(i);
											isWidgetPresent = true;
											E12Global.getInstance().setMyCircleClick(false);
											//Added by Sagar M. on 02/11/18 [Removing and adding local js each time on menu click]Start
											E12CommonUtils.printOnConsole("BaseE12 inside remove js file objname ["+e12TransInfoObj.getObjName()+"]");
											E12CommonUtils.getInstance().removeJSFile(e12TransInfoObj.getObjName(), "js");
										    E12CommonUtils.printOnConsole("BaseE12 inside include jsfileName------"+e12TransInfoObj.getObjName());
											String jsFilePath = E12Global.getHostUrl() + "/ibase/webitm/js/"+e12TransInfoObj.getObjName()+".js";
											E12CommonUtils.getInstance().includeJSFile(jsFilePath);
											//Added by Sagar M. on 02/11/18 [Removing and adding local js each time on menu click]End
											break;
										}
										else
										{
											isWidgetPresent = false;
											//Added by shrutika on 20-07-17 For multiple click handle in delete report and confirm report
											E12Global.getInstance().setMyCircleClick(true);//shrutika
										}
										//Changed by Prasad on 03/05/18 [open existing selected menu's] END
									}
									//Added By Suraj on 28-feb-2017 [To handle multiple click on Calendar Menu]End
									else
									{
										if( newE12PnlGenWidget != null && newE12PnlGenWidget.getWidgetCount() > 1 )
										{
											if ( newE12PnlGenWidget.getWidgetCount() >= 2  )
											{
												TextBox tbID = ( TextBox ) newE12PnlGenWidget.getWidget( 1 );
												E12CommonUtils.printOnConsole("1418 : menuId ["+menuIdStr+"] tabId ["+tbID.getText()+"] isDcrOpen ["+isDcrOpen+"]");
												//Added by shrutika on 17-07-17 [Start] for Call Report Status menu issue
												if( menuIdStr.equalsIgnoreCase( tbID.getText() ) )
												{
													if("true".equalsIgnoreCase( isDcrOpen ) )
													{
														isWidgetPresent = false;
														isDcrOpen = "false";
//													e12TransBrow.e12TabPanel.remove(i);
														e12TransBrow.e12TabPanel.remove( tbID.getText(), i);
													}
													else
													{
														e12TransBrow.e12TabPanel.selectTab(i);
														isWidgetPresent = true;
														//Added by Prasad on 03/05/18 [open existing selected menu's]
														//Added by Sagar M. on 02/11/18 [Removing and adding local js each time on menu click]Start
														E12CommonUtils.printOnConsole("BaseE12 inside remove js file objname ["+e12TransInfoObj.getObjName()+"]");
														E12CommonUtils.getInstance().removeJSFile(e12TransInfoObj.getObjName(), "js");
													    E12CommonUtils.printOnConsole("BaseE12 inside include jsfileName------"+e12TransInfoObj.getObjName());
														String jsFilePath = E12Global.getHostUrl() + "/ibase/webitm/js/"+e12TransInfoObj.getObjName()+".js";
														E12CommonUtils.getInstance().includeJSFile(jsFilePath);
														//Added by Sagar M. on 02/11/18 [Removing and adding local js each time on menu click]End
														break;
													}
												}
												//Added by shrutika on 17-07-17 [End] for Call Report Status menu issue
												/*if( menuIdStr.equalsIgnoreCase( tbID.getText() ) )
												{
													e12TransBrow.e12TabPanel.selectTab(i);
													isWidgetPresent = true;
												}*/
											}
										}
									}
									//Changed by Sandeep S. on 23-02-17 End
								}
								E12CommonUtils.printOnConsole("isWidgetPresent ..1544"+isWidgetPresent);
								if( isWidgetPresent == false )
								{
									//Added by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user] START
									int tabIndex = 1;
									if ( e12TabCount == 0 )
									{
										tabIndex = 0;
									}
									//Added by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user] END
									//Changed By Mahesh Patidar on 23-OCT-13 [to add Z objType for GWT process Window]
//								if( objType.equals( "W" ) )
									if( objType.equals( "W" ) || objType.equals( "Z" ) )
									{
										//changed by parikshit on 29/12/16 [to add side panel] start
										/*EntryWrapper entry = new EntryWrapper();
										entry.setComment( e12TransInfoObj.getComment() );
										entry.setIcon( e12TransInfoObj.getIcon() );
										entry.setId( e12TransInfoObj.getId() );
										entry.setObjName( e12TransInfoObj.getObjName() );
										entry.setObjType( e12TransInfoObj.getObjType() );
										entry.setTitle( e12TransInfoObj.getTitle() );

										E12Wizard e12Wizard = new E12Wizard(entry, instanceIdStr, e12TransInfoObj.getId(), callerInterface);
										VerticalPanel vPanel  = e12Wizard.getWizardPageRootPanel();
										vPanel.setStyleName("tabContentPanel");
										e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, title);
										e12TransBrow.e12TabPanel.selectTab( 1 );*/

										//Added by shrutika on 18-01-19 [Start] for getting first widget on click of close tab for remove user activities.
										E12CommonUtils.printOnConsole("inside opentansaction....1803");
										TextBox tabIdTxtBx = new TextBox();
										tabIdTxtBx.setText(menuIdStr);
										tabIdTxtBx.setVisible( false );
										tabIdTxtBx.setHeight("0px");
										//Added by shrutika on 18-01-19 [End] for getting first widget on click of close tab for remove user activities.

										E12SidePanelContainers e12SidePanelContainers = new E12SidePanelContainers(e12TransInfoObj, instanceIdStr, callerInterface , null);
										//Added By Pratheek on 28/6/17[pass the map to set in Side Panel]-Start
										e12SidePanelContainers.setWizardMap(wizardParamMap);
										//Added By Pratheek on 28/6/17[pass the map to set in Side Panel]-End
										VerticalPanel vPanel = (VerticalPanel) e12SidePanelContainers.getWidget();
										vPanel.setStyleName("tabContentPanel");
										//Added by shrutika on 18-01-19 [Start] for getting first widget on click of close tab for remove user activities.
										vPanel.add(tabIdTxtBx);
										//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
										e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), tabIndex, title);
										//changed by parikshit on 29/12/16 [to add side panel] end
										e12TransBrow.e12TabPanel.selectTab( tabIndex );
									}
									else if( objType.equals("T") )
									{

										//Added by shrutika on 18-01-19 [Start] for getting first widget on click of close tab for remove user activities.
										E12CommonUtils.printOnConsole("inside opentansaction....1803");
										TextBox tabIdTxtBx = new TextBox();
										tabIdTxtBx.setText(menuIdStr);
										tabIdTxtBx.setVisible( false );
										tabIdTxtBx.setHeight("0px");
										//Added by shrutika on 18-01-19 [End] for getting first widget on click of close tab for remove user activities.
										//changed by parikshit on 29/12/16 [to add side panel] start
										/*E12HomePage e12HomePage = new E12HomePage();
										VerticalPanel vPanel =  e12HomePage.createE12HomePage( e12TransInfoObj, menuIdStr );*/
										E12SidePanelContainers e12SidePanelContainers = new E12SidePanelContainers(e12TransInfoObj, instanceIdStr, callerInterface, null);
										VerticalPanel vPanel =  e12SidePanelContainers.getWidget();

										//Added by shrutika on 18-01-19 [Start] for getting first widget on click of close tab for remove user activities.
										vPanel.add(tabIdTxtBx);
										vPanel.setStyleName("tabContentPanel");
										//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
										e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), tabIndex, e12SidePanelContainers.e12HomePage, title, "");
										//changed by parikshit on 29/12/16 [to add side panel] end
										e12TransBrow.e12TabPanel.selectTab(tabIndex);
									}
									//Added By UMAKANTA On 12/FEB/2015 [ For display report through Browser Interface ] Start
									else if( objType.equals("R") )
									{
										//Added by Pratheek on 06-03-18[to call Report in Browser]-Start
										//Added by Prasad on 02/11/17 [implementation of side panel for report] START
										E12SidePanelContainers e12SidePanelContainers = new E12SidePanelContainers(e12TransInfoObj, instanceIdStr, callerInterface, null);
										//E12Report e12Report = new E12Report( e12TransInfoObj );
										//Added by shrutika on 18-01-19 [Start] for getting first widget on click of close tab for remove user activities.
										TextBox tabIdTxtBx = new TextBox();
										tabIdTxtBx.setText(menuIdStr);
										tabIdTxtBx.setVisible( false );
										tabIdTxtBx.setHeight("0px");
										//Added by shrutika on 18-01-19 [End] for getting first widget on click of close tab for remove user activities.
										//VerticalPanel vTabPanel =  new VerticalPanel();
										VerticalPanel vTabPanel =  e12SidePanelContainers.getWidget();
										//vTabPanel.add( e12Report );
										//Added by Prasad on 02/11/17 [implementation of side panel for report] END
//									vTabPanel.add( tabIdTxtBx );
										//vTabPanel.setStylePrimaryName( "mainPage-Container" );
										E12CommonUtils.printOnConsole("Before Insert method in TabPanel 1666!!!!");
//									e12TransBrow.e12TabPanel.insert( vTabPanel, getTabWidget( vTabPanel, title ), 1);

										//Added by shrutika on 18-01-19 [Start] for getting first widget on click of close tab for remove user activities.
										vTabPanel.add(tabIdTxtBx);
										// added mahesh saggam on 10-OCT-19 [to add poppanel which slides in and out the menupanel on maximize]
										vTabPanel.setStyleName("reportTabContentPanel");
										//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
										e12TransBrow.e12TabPanel.insertTab( vTabPanel, getTabWidget( vTabPanel, title ), tabIndex, title);
										e12TransBrow.e12TabPanel.selectTab(tabIndex);
										//Added by Pratheek on 06-03-18[to call Report in Browser]-End
									}//Added By UMAKANTA On 12/FEB/2015 [ For display report through Browser Interface ] End
									else if( objType.equals("G") )
									{
										VerticalPanel vPanel =  new E12TransPanelGenerator().createE12TransPanel( e12TransInfoObj );
										vPanel.setStyleName("tabContentPanel");
										//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
										e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), tabIndex, title);
										e12TransBrow.e12TabPanel.selectTab(tabIndex);
									}
									//Added by Pratheek on 25-05-18[to call the process screen same as wizard]-Start
									else if( objType.equals("P") )
									{
										if(instanceIdStr == null)
										{
											instanceIdStr = E12Constants.userID + generateRandomNo();;
										}
										//Added by shrutika on 18-01-19 [Start] for getting first widget on click of close tab for remove user activities.
										E12CommonUtils.printOnConsole("inside opentansaction....1803");
										TextBox tabIdTxtBx = new TextBox();
										tabIdTxtBx.setText(menuIdStr);
										tabIdTxtBx.setVisible( false );
										tabIdTxtBx.setHeight("0px");
										//Added by shrutika on 18-01-19 [End] for getting first widget on click of close tab for remove user activities.
//									VerticalPanel vPanel = ( VerticalPanel ) ( new E12PanelGenerator().createE12TransPanel( e12TransBrow, e12TransInfoObj, instanceIdStr ) );
										//e12TransBrow.e12TabPanel.insert( vPanel, title, 1 );
										E12SidePanelContainers e12SidePanelContainers = new E12SidePanelContainers(e12TransInfoObj, instanceIdStr, callerInterface, null);
										E12CommonUtils.printOnConsole("menuIdStr 1663!!!!!{"+menuIdStr+"}");
										VerticalPanel vPanel =  e12SidePanelContainers.getWidget();

										vPanel.setStylePrimaryName( "tabContentPanel" );
										//Added by shrutika on 18-01-19 [Start] for getting first widget on click of close tab for remove user activities.
										vPanel.add(tabIdTxtBx);
										//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
										e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), tabIndex, title);
										e12TransBrow.e12TabPanel.selectTab( tabIndex );
										if(E12Global.isGalaxy())
										{
											((Element) vPanel.getElement().getFirstChild().getChild(1)).setAttribute("style", "height: 0px;");
										}
									}
									//Added by Pratheek on 25-05-18[to call the process screen same as wizard]-End
									else if( objType.equals("C") )
									{
										if(instanceIdStr == null)
										{
											instanceIdStr = E12Constants.userID + generateRandomNo();;
										}
										E12PanelGenerator e12PanelGenerator = new E12PanelGenerator();
										VerticalPanel vPanel = ( VerticalPanel ) ( e12PanelGenerator.createE12TransPanel( e12TransInfoObj, instanceIdStr ) );
										vPanel.setStylePrimaryName( "tabContentPanel" );
										//Changed By Suraj on 19-01-2017 [To set objName and objType on tab selection]
										//e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, title);
										//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
										e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), tabIndex, e12PanelGenerator, title, menuIdStr.replace(".", "_"));
										e12TransBrow.e12TabPanel.selectTab(tabIndex);
										((Element) vPanel.getElement().getFirstChild().getChild(1)).setAttribute("style", "height: 0px;");
									}
									//Added by Savita Yadav on 18-05-2015 [For Bulk delete attachment]-Start
									else if( objType.equals("D") )
									{
										VerticalPanel vPanel =  new E12BulkDelete().createSearchPanel(e12TransInfoObj);
										vPanel.setStyleName("tabContentPanel");
										//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
										e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), tabIndex, title);
										e12TransBrow.e12TabPanel.selectTab(tabIndex);
									}
									//Added by Savita Yadav on 18-05-2015 [For Bulk delete attachment]-End
									//Added by Chetan Mahajan on 08-09-2015 [For Workflow pending transaction Req id : W15FSUN005] - Start
									else if( objType.equals("H") )
									{
										WFPRCDataView e12workflowstatus = new WFPRCDataView( e12TransInfoObj );
										VerticalPanel vTabPanel = new VerticalPanel();
										vTabPanel.add(e12workflowstatus);
										vTabPanel.setStylePrimaryName( "mainPage-Container-panel" );
										//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
										e12TransBrow.e12TabPanel.insert( vTabPanel, getTabWidget( vTabPanel, title ), tabIndex);
										e12TransBrow.e12TabPanel.selectTab(tabIndex);
									}
									//Added by Chetan Mahajan on 08-09-2015 [For Workflow pending transaction Req id : W15FSUN005] - End
									//Added By Prasad on 15/06/15 [to add E (for Document Upload with Transaction)] START
									else if( objType.equals("E") )
									{
										VerticalPanel vPanel = null;
										if ( e12TransInfoObj.getObjName().indexOf("/") != -1 )
										{
											vPanel = ( VerticalPanel ) ( new E12PanelGenerator().createE12TransPanel( e12TransInfoObj, instanceIdStr ) );
											//Changes by Prajyot - 19/07/2019 [CSS class name change as per other tabs created]
											//vPanel.setStylePrimaryName( "mainLayoutStyle" );
											vPanel.setStylePrimaryName( "tabContentPanel" );
											//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
											e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), tabIndex, title);
											if(E12Global.isGalaxy())
											{
												((Element) vPanel.getElement().getFirstChild().getChild(1)).setAttribute("style", "height: 0px;");
											}
										}
										else
										{
											//Changed by Pankaj P on 24/02/2021 [changed as per new changes for homepage] START
											/*E12HomePage e12HomePage = new E12HomePage();
											vPanel =  e12HomePage.createE12HomePage( e12TransInfoObj, menuIdStr );
											vPanel.setStyleName("tabContentPanel");
											e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, e12HomePage, title, "");*/
											
											TextBox tabIdTxtBx = new TextBox();
											tabIdTxtBx.setText(menuIdStr);
											tabIdTxtBx.setVisible( false );
											tabIdTxtBx.setHeight("0px");
											
											E12SidePanelContainers e12SidePanelContainers = new E12SidePanelContainers(e12TransInfoObj, instanceIdStr, callerInterface, null);
											vPanel = e12SidePanelContainers.getWidget();
											vPanel.setStyleName("tabContentPanel");

											vPanel.add(tabIdTxtBx);
											//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
											e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), tabIndex, e12SidePanelContainers.e12HomePage, title, "");
											//Changed by Pankaj P on 24/02/2021 [changed as per new changes for homepage] END
										}
										//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
										e12TransBrow.e12TabPanel.selectTab(tabIndex);
									}
									//Added By Prasad on 15/06/15 [to add E (for Document Upload with Transaction)] END
									//Added By Prashant Chavan  on 26-Aug-15 [ For Survey] START
									else if( objType.equals("S") )
									{
										E12Survey e12Survey = new E12Survey( e12TransInfoObj );
										VerticalPanel vTabPanel =  new VerticalPanel();
										vTabPanel.add(e12Survey);
										vTabPanel.setStylePrimaryName( "mainPage-Container" );
										//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
										e12TransBrow.e12TabPanel.insert( vTabPanel, getTabWidget( vTabPanel, title ), tabIndex);
										e12TransBrow.e12TabPanel.selectTab(tabIndex);
									}
									//Added By Prashant Chavan  on 26-Aug-15 [ For Survey] END
									//Added By Prajyot Rumde on 19-JUN-18 [ For Dashboard Load From Menu for objType A] START
									else if( objType.equals("A") )
									{
										//Changed by Pravin K [To show message notification panel] on 27-NOV-19 START 
										if("message_comp".equalsIgnoreCase( E12Constants.objName) ) 
										{
											
											E12CommonUtils.printOnConsole("1: Notification component ");
											VerticalPanel notificationScrPanel = new VerticalPanel();
											
											NotificationPanel notificationPanel = new NotificationPanel();
											notificationScrPanel.add(notificationPanel.getAddUI());
											notificationScrPanel.setStyleName("notificatinScrollPanel");
											
											notificationScrPanel.getElement().setAttribute("data-tab-id", menuIdStr);
											//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
											e12TransBrow.e12TabPanel.insert(notificationScrPanel, getTabWidget( notificationScrPanel, title ), tabIndex);
											e12TransBrow.e12TabPanel.selectTab(tabIndex);
										}
										else
										{
											
											E12ANGReport angReport = new E12ANGReport(e12TransInfoObj);
											VerticalPanel vTabPanel =  new VerticalPanel();
											E12CommonUtils.printOnConsole("objType and angReport  !!!!!{"+objType+"}["+ angReport + "]");
											vTabPanel.add(angReport);
											TextBox tbID = new TextBox();
											tbID.setText( e12TransInfoObj.getId() );
											tbID.setVisible( false );
											vTabPanel.add( tbID );
											vTabPanel.setStylePrimaryName( "mainPage-Container" );
											//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
											e12TransBrow.e12TabPanel.insert( vTabPanel, getTabWidget( vTabPanel, title ), tabIndex);
											e12TransBrow.e12TabPanel.selectTab(tabIndex);
										}
										//Changed by Pravin K [To show message notification panel] on 27-NOV-19 END
									}
									//Added By Prajyot Rumde on 19-JUN-18 [ For Dashboard Load From Menu for objType A]  END
									//Added By Shrutika N. on 16-12-2020 added new obj_type j to open angular component for incentive process to show a processid according to win_name - start
									else if( objType.equals("J") ) 
									{
										E12CommonUtils.printOnConsole("inside objType j.............2142");
										
										VerticalPanel vTabPanel =  new VerticalPanel();
										final String targetId = "generalized_process";
										
										String objName = e12TransInfoObj.getObjName();
										E12CommonUtils.printOnConsole("inside objType j.............2155"+objName);
										
										final JSONObject configData = new JSONObject();
										configData.put("componentName", new JSONString(targetId));
										configData.put("targetId", new JSONString(targetId));
										configData.put("OBJ_NAME", new JSONString(objName));
										
										E12CommonUtils.printOnConsole("inside objType j.............2162"+configData.toString());
										
										E12AngularComponent e12AngularComponent = new E12AngularComponent( targetId , configData.toString() );
										vTabPanel.add(e12AngularComponent);
										
										TextBox tbID = new TextBox();
										tbID.setText( e12TransInfoObj.getId() );
										tbID.setVisible( false );
										vTabPanel.add( tbID );
										vTabPanel.setStylePrimaryName( "mainPage-Container" );
										//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
										e12TransBrow.e12TabPanel.insert( vTabPanel, getTabWidget( vTabPanel, title ), tabIndex);
										e12TransBrow.e12TabPanel.selectTab(tabIndex);
									}
									//Added By Shrutika N. on 16-12-2020 added new obj_type j to open angular component for incentive process to show a processid according to win_name - end
									//Added By nikhil on 23-02-2022 added new obj_type v to open angular component for shared visual to show a processid according to win_name [start]
									else if( objType.equals("V") ) 
									{
										E12CommonUtils.printOnConsole("inside objType v.............2409");
										
										VerticalPanel vTabPanel =  new VerticalPanel();
										final String targetId = "dash_def";
										
										String objName = e12TransInfoObj.getObjName();
										E12CommonUtils.printOnConsole("inside objType v.............2415"+objName);
										
										final JSONObject configData = new JSONObject();
										configData.put("componentName", new JSONString(targetId));
										configData.put("targetId", new JSONString(targetId));
										configData.put("OBJ_NAME", new JSONString(objName));
										
										E12CommonUtils.printOnConsole("inside objType v.............2422"+configData.toString());
										
										E12AngularComponent e12AngularComponent = new E12AngularComponent( targetId , configData.toString() );
										vTabPanel.add(e12AngularComponent);
										
										TextBox tbID = new TextBox();
										tbID.setText( e12TransInfoObj.getId() );
										tbID.setVisible( false );
										vTabPanel.add( tbID );
										vTabPanel.setStylePrimaryName( "mainPage-Container" );
										e12TransBrow.e12TabPanel.insert( vTabPanel, getTabWidget( vTabPanel, title ), 1);
										e12TransBrow.e12TabPanel.selectTab(1);
									}
									//Added By nikhil on 23-02-2022 added new obj_type v to open angular component for shared visual to show a processid according to win_name [End]
									else
									{
										if(instanceIdStr == null)
										{
											instanceIdStr = E12Constants.userID + generateRandomNo();;
										}
										VerticalPanel vPanel = ( VerticalPanel ) ( new E12PanelGenerator().createE12TransPanel( e12TransInfoObj, instanceIdStr ) );
										//e12TransBrow.e12TabPanel.insert( vPanel, title, 1 );
										//Changes by Prajyot - 19/07/2019 [CSS class name change as per other tabs created]
										//vPanel.setStylePrimaryName( "mainLayoutStyle" );
										vPanel.setStylePrimaryName( "tabContentPanel" );
										//Changed by Shubham P on 06/05/2021 [set tabIndex in case of dashboard not defined for login user]
										e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), tabIndex, title);
										e12TransBrow.e12TabPanel.selectTab( tabIndex );
										if(E12Global.isGalaxy())
										{
											((Element) vPanel.getElement().getFirstChild().getChild(1)).setAttribute("style", "height: 0px;");
										}
									}
								}
							}
							//Changes By Prajyot on 24-08-2011 [ To restrict user from opening more than 12 Tabs ] Ends
						}
						else
						{
							Window.alert( invalidObj );
						}
					}
					else
					{
						//Added by sunny soni for showing restricted menu title message on 09-Feb-22 [Start]
						String msg = "";
						if (E12CommonUtils.checkNull(e12TransInfoObj.getTitle()).length() > 0)
						{
							//msg = e12TransInfoObj.getTitle() + " is not accessible for current Devices";
							msg = e12TransInfoObj.getTitle() + " is " + constants.getRestrictPartMessage();
						}
						else 
						{
							msg = e12TransInfoObj.getRestrictMsg();
						}
						Window.alert( msg );
						//Added by sunny soni for showing restricted menu title message on 09-Feb-22 [End]
						//Window.alert( e12TransInfoObj.getRestrictMsg() );
					}
					////Changed By Suraj on 14-12-2016 [For menu restriction]End
				}
			}
			catch (Exception e)
			{
				E12CommonUtils.printOnConsole("Exception in openTransaction ["+e.getMessage()+"]");
				e.printStackTrace();
			}
		}

		public void openBulletinBoard( E12CollabDataWrapper e12CollabDataWrapper )
		{

			boolean isCollabPresent = false;
			int tabToReplace = 1;
			//Changed By Mahesh Patidar on 22/DEC/12
			String grpName = constants.setBulletinBoardLbl();
			if( e12CollabDataWrapper != null )
			{
				int e12TabCount = e12TransBrow.e12TabPanel.getWidgetCount();
				if ( e12TabCount > 12 )
				{
					for(int i = 1 ; i < e12TabCount ; i++)
					{
						VerticalPanel vCollabPanel =( VerticalPanel ) e12TransBrow.e12TabPanel.getWidget( i );
						if ( vCollabPanel.getWidgetCount() >= 2  )
						{
							TextBox txtBox = ( TextBox )vCollabPanel.getWidget( 1 );
							String groupName = txtBox.getText();

							if ( grpName.equalsIgnoreCase( groupName ) )
							{
								e12TransBrow.e12TabPanel.selectTab( i );
								tabToReplace = i ;
								isCollabPresent = true;
								break;
							}
						}
					}
					if( ! isCollabPresent )
					{
						Window.alert( moreThan12 );
						return;
					}
				}
				else
				{
					for(int i = 1 ; i < e12TabCount ; i++)
					{
						VerticalPanel vCollabPanel =( VerticalPanel ) e12TransBrow.e12TabPanel.getWidget( i );
						if ( vCollabPanel.getWidgetCount() >= 2  )
						{
							TextBox txtBox = ( TextBox )vCollabPanel.getWidget( 1 );
							String groupName = txtBox.getText();
							if ( grpName.equalsIgnoreCase( groupName ) )
							{
								e12TransBrow.e12TabPanel.selectTab( i );
								tabToReplace = i ;
								isCollabPresent = true;
								break;
							}
						}
					}
				}
				if( e12TabCount > 1 & isCollabPresent )
				e12TransBrow.e12TabPanel.remove( tabToReplace );

				VerticalPanel vPanel = new CollabFeedDetailPanel().createCollabFeedDetailPanel( e12CollabDataWrapper, grpName );
				//e12TransBrow.e12TabPanel.insert( vPanel, grpName, tabToReplace );
				e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, grpName ), tabToReplace, grpName);
				e12TransBrow.e12TabPanel.selectTab( tabToReplace );
			}
		}

		public void openFavourite(TreeItem item)
		{
			VerticalPanel me12EditorPanel = null;
			if( item != null && item.getChildCount() == 0 )
			{
				Boolean isFavouritePresent = false ;
				String tabId = "Favourite";
				int tabToReplace = 1;
				int tabCount = e12TransBrow.e12TabPanel.getWidgetCount();
				EntryWrapper entry = ( EntryWrapper )item.getUserObject();

				if( entry != null )
				{
					try
					{
						String textid = E12Global.checkNull( entry.getId() ).trim();
						String objType = entry.getObjType();
						String objName = entry.getObjName();
						E12CommonUtils.printOnConsole( "tabCount ["+tabCount+"] " );
						for( int i = 1; i < tabCount ; i++ )
						{
							me12EditorPanel = ( VerticalPanel )e12TransBrow.e12TabPanel.getWidget( i );
							if( me12EditorPanel.getWidgetCount() >= 2 )
							{
								TextBox txtBox =( TextBox ) me12EditorPanel.getWidget( 1 );
								String txtBoxId = txtBox.getText();
								if( E12Global.checkNull( textid ).equalsIgnoreCase( txtBoxId ) )
								{
									e12TransBrow.e12TabPanel.selectTab( i );
									tabToReplace = i;
									isFavouritePresent = true ;
									break;
								}
							}
						}

						if( tabCount > 12 )
						{
							if( ! isFavouritePresent )
							{
								Window.alert( moreThan12 );
								return;
							}
						}

						if( tabCount > 1 && isFavouritePresent)
						e12TransBrow.e12TabPanel.remove( tabToReplace );

						if( "T".equalsIgnoreCase( objType ))
						{
							E12HomePage e12HomePage = new E12HomePage();
							me12EditorPanel  =  e12HomePage.createE12HomePage( entry, textid );
							me12EditorPanel.setStyleName("tabContentPanel");
							e12TransBrow.e12TabPanel.insertTab( me12EditorPanel, getTabWidget( me12EditorPanel, entry.getTitle() ), tabToReplace, e12HomePage, entry.getTitle(), "");
							e12TransBrow.e12TabPanel.selectTab( tabToReplace );
						}
						else if( "W".equalsIgnoreCase( objType ) )
						{
							E12TransInfoObj e12TransInfoObj = new E12TransInfoObj( textid, null, "Unknown", entry.getObjName(), entry.getObjType(),"Unknown-comment" );
							String randomID = E12Constants.userID + generateRandomNo();
						    E12CommonUtils.printOnConsole( "Call to E12Wizard file" );
							E12Wizard e12Wizard = new E12Wizard( entry, randomID, e12TransInfoObj.getId(), callerInterface );
							me12EditorPanel  = e12Wizard.getWizardPageRootPanel();
							me12EditorPanel.setStyleName("tabContentPanel");
							e12TransBrow.e12TabPanel.insertTab( me12EditorPanel, getTabWidget( me12EditorPanel, entry.getTitle() ), tabToReplace, entry.getTitle());
							e12TransBrow.e12TabPanel.selectTab( tabToReplace );
						}
					}
					catch (Throwable e)
					{
						Window.alert( " Exception :: addFavouriteTree() " + e.toString() );
					}
				}
			}
		}

		public void openBulletinBoard( String id, String objName, String objType, String title )
		{
			String groupId = E12Global.checkNull( id );
			E12CommonUtils.printOnConsole( "GroupId ["+groupId+"]" );
			E12CollabDataWrapper e12CollabDataWrapper = null ;
			Set<Entry<String, E12CollabDataWrapper>> entrySet = E12CollabFeedGen.wraperColabHM.entrySet();
			Iterator<Entry<String, E12CollabDataWrapper>> entryIt =  entrySet.iterator();
			while (entryIt.hasNext())
			{
				Map.Entry<java.lang.String, ibase.e12ria.client.E12CollabDataWrapper> entry = (Map.Entry<java.lang.String, ibase.e12ria.client.E12CollabDataWrapper>) entryIt
						.next();
				String key = entry.getKey().trim();
				if( groupId.equalsIgnoreCase(key) )
				{
					e12CollabDataWrapper = entry.getValue();
					break;
				}
			}
			openBulletinBoard( e12CollabDataWrapper );
		}
		//Changed by Suraj on 14-12-2016 [To open workflow from Intro page]Start
		public void openWorkflw( final String id, final String title, final String wrkflwType, final String defaultRefId )
		{
			E12CommonUtils.getInstance().setRefId( defaultRefId );
			e12MenuPanel.e12Workflow.getTree( E12Constants.profileID, E12Constants.conApplNm, new Callback<String, String>() {

				@Override
				public void onSuccess(String result)
				{
					TreeItem wrkflwChldItm = e12MenuPanel.e12Workflow.wrkflwTree.getItem(0);
					int itmCount =  wrkflwChldItm.getChildCount();
					E12CommonUtils.printOnConsole( "itmCount ["+itmCount+"]" );
					e12HeaderPanel.e12ApplicationMenuBar.selectApplication("WRK_OPT");

					for( int i = 0; i < itmCount; i++ )
					{
						E12TreeItem item = (E12TreeItem) wrkflwChldItm.getChild(i);
						E12WrkflwInfoObj e12WrkflwInfoObj = ( E12WrkflwInfoObj )item.getUserObject();
						String status = e12WrkflwInfoObj.getStatus();
						E12CommonUtils.printOnConsole("status ["+status+"] workflow type ["+wrkflwType+"]");
//						if( "U".equalsIgnoreCase( status ) && "I".equalsIgnoreCase(wrkflwType) ) // Inbox
//						{
//							//e12MenuPanel.e12Workflow.openWorkflw( item );
//							break;
//						}
//						else if( "S".equalsIgnoreCase( status ) && "A".equalsIgnoreCase(wrkflwType) ) // Approved
//						{
//							e12MenuPanel.e12Workflow.openWorkflw( item );
//							break;
//						}
//						else if( "R".equalsIgnoreCase( status ) && "R".equalsIgnoreCase(wrkflwType) ) // Rejected
//						{
//							e12MenuPanel.e12Workflow.openWorkflw( item );
//							break;
//						}
					}
				}

				@Override
				public void onFailure(String reason)
				{
					Window.alert("Failed to get response while calling workflow");
				}
			} );
		}
		//Changed by Suraj on 14-12-2016 [To open workflow from Intro page]End

		//Added By Sainath T On 15-10-2018 [For Open Transaction from Vision Assistant]-START
		public void openTransactions(String objectName)
		{
			try
			{
				E12TransInfoObj e12TransInfoObj = ObjDetails.get( objectName ).getE12TransInfoObj();
				if(e12TransInfoObj != null)
				{
					e12HeaderPanel.e12ApplicationMenuBar.selectApplication("HOME_OPT");
					openTransaction(e12TransInfoObj);
				}
				else
				{
					try
					{
						final String objName = objectName;
						HashMap<String, String> paramMap = new HashMap<String, String>();

						paramMap.put("ACTION", "OBJ_ITM2MENU_DETAILS");
						paramMap.put("OBJ_NAME", objectName);
						paramMap.put("dummyInt", ""+Math.random());
						String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);
						E12CommonUtils.printOnConsole("Param String:["+paramString+"]");

						E12Global.getInstance().setLoading(true);
						String url = "/ibase/WEBITMRIARequestHandlerServlet?" + paramString ;

						RequestBuilder requestBuilder = new RequestBuilder( RequestBuilder.GET, url );
						requestBuilder.sendRequest( null, new RequestCallback() {

							@Override
							public void onResponseReceived(Request request, Response response)
							{
								try
								{
									String reqResponse = response.getText();
									E12CommonUtils.printOnConsole("rerResponse["+reqResponse+"]");
									if( E12Global.getInstance().checkErrorException(response, 1) )
									{
										String menuPath = "", descr = "", iconPath = "", objType = "";
										if ( reqResponse.length() > 0 )
										{
											Document document = XMLParser.parse( reqResponse );
											NodeList detailNList = document.getElementsByTagName("detail");
											Node eachDetailNode = detailNList.item(0);
											NodeList eachDetailChildNList = eachDetailNode.getChildNodes();

											for(int i = 0; i < eachDetailChildNList.getLength(); i++)
											{
												String nodeName = eachDetailChildNList.item(i).getNodeName();
												String nodeValue = eachDetailChildNList.item(i).getFirstChild().getNodeValue();

												switch ( nodeName )
												{
												case "menuPath" :
												{
													menuPath = nodeValue;
												}
												break;
												case "descr" :
												{
													descr = nodeValue;
												}
												break;
												case "iconPath" :
												{
													iconPath = nodeValue;
												}
												break;
												case "objType" :
												{
													objType = nodeValue;
												}
												break;
												}
											}
											E12CommonUtils.printOnConsole("menuPath["+menuPath+"] descr["+descr+"] iconPath["+iconPath+"] object_type["+objType+"]");
											E12TransInfoObj e12TransInfoObj =new E12TransInfoObj( menuPath, iconPath, descr, objName, objType, "" );
											ObjDetails.get( objName ).setE12TransInfoObj( e12TransInfoObj );

											e12HeaderPanel.e12ApplicationMenuBar.selectApplication("HOME_OPT");
											openTransaction( e12TransInfoObj );
										}
										else
										{
											E12CommonUtils.printOnConsole("rerResponse is null");
											Window.alert( E12Constants.constants.invalidObjName() );
										}
									}
								}
								catch (Exception e)
								{
									e.printStackTrace();
									E12CommonUtils.printOnConsole("Exception occurrend for obect name["+objName+"] while processing response");
								}
								E12Global.getInstance().setLoading(false);
							}

							@Override
							public void onError(Request request, Throwable exception)
							{
								E12Global.getInstance().setLoading(false);
								Window.alert( "Error : " + exception.getMessage() );
							}
						});
					}
					catch(Exception e)
					{
						E12Global.getInstance().setLoading(false);
						E12CommonUtils.printOnConsole("Exception occurrend for obect name["+objectName+"] while calling homepage");
					}

					E12CommonUtils.printOnConsole("object 2242==>");
				}
			} catch (Exception e) {
				e.printStackTrace();
				System.out.println("openTransactions exception==>"+e.getMessage());
			}
			E12CommonUtils.printOnConsole("object 2248==>");
		}
		//Added By Sainath T On 15-10-2018 [For Open Transaction from Vision Assistant]-END

		public void openTransaction(String id, String objName, String objType, String title )
		{
			//added by vishal pathare on 1.9.17 for[image icon related issue in wizard].
			//Added by Sagar B. for opening transaction [29-Aug-18]START
			E12TransInfoObj e12TransInfoObj = ObjDetails.get(objName).getE12TransInfoObj();
			if( e12TransInfoObj == null )
			{
				String menuIcon = getMenuIconInTree( objName, objType );
				E12CommonUtils.printOnConsole(" menuIcon ["+menuIcon+"]" );
				e12TransInfoObj = new E12TransInfoObj(E12Global.checkNull(id), E12Global.checkNull( menuIcon ), E12Global.checkNull(title), E12Global.checkNull(objName), E12Global.checkNull(objType), "");
				ObjDetails.get(objName).setE12TransInfoObj(e12TransInfoObj);
			}
			//Added by Sagar B. for opening transaction [29-Aug-18]END
			//Added By Suraj on 14-Feb-2017 [To open My Calendar from workflow xsl with home page menu]
			e12HeaderPanel.e12ApplicationMenuBar.selectApplication("HOME_OPT");
			openTransaction( e12TransInfoObj );
		}

		//Added by Prasad on 02/11/18 [to perform link action] START
		/**
		 * e.g. performLinkAction( '01SOD0397', 'sorder', 'sorder', '1', '', '', 'Link', 'sorder21', '', '', '' );
		 *
		 * @param pkFieldValue
		 * @param objName
		 * @param targetObjName
		 * @param linkType
		 * @param linkUri
		 * @param linkArgmnt
		 * @param linkTitle
		 * @param linkForm
		 * @param qryStr
		 * @param fieldName
		 * @param linkImage
		 */
		//Changed By Pankaj T. on 04-12-18 added link configuration for link_type 3 ("" or 1 - open in side panel, 2 - open separately, 3 - only add in context menu, 4 - only add in side panel)
		public void performLinkAction( String pkFieldValue, String objName, String targetObjName, String linkType, String linkUri, String linkArgmnt, String linkTitle, String linkForm, String qryStr, String fieldName, String linkImage, String showInSidePanel )
		{
			E12TranActionLinks actionLinks = new E12TranActionLinks();
			//Changed By Pankaj T. on 04-12-18 added link configuration for link_type 3 ("" or 1 - open in side panel, 2 - open separately, 3 - only add in context menu, 4 - only add in side panel)
			actionLinks.performLinkAction(pkFieldValue, objName, targetObjName, linkType, linkUri, linkArgmnt, linkTitle, linkForm, qryStr, false, fieldName, linkImage, showInSidePanel);
		}
		//Added by Prasad on 02/11/18 [to perform link action] END

        //Added by Jatin M on 24-Jun-2022 [To export logout method as javascript function] - START
        public void logoutUser()
        {
            E12CommonUtils.printOnConsole("22062022 Inside BaseE12 logoutUser");
            E12UserInfo e12UserInfo = new E12UserInfo();
            e12UserInfo.logoutUser();
        }
        //Added by Jatin M on 24-Jun-2022 [To export logout method as javascript function] - END
		/**
		 * This method export methods for calling from handwritten java script
		 */
		public native void exportMethods( BaseE12 baseE12 )
		/*-{
			$wnd.setWizardParamMapGWT = $entry(baseE12.@ibase.e12ria.client.BaseE12::setWizardParamMap(Ljava/lang/String;));
			$wnd.isDcrExistGWT = $entry(baseE12.@ibase.e12ria.client.BaseE12::isDcrExist(Ljava/lang/String;));
			//Added By Sainath T On 15-10-2018 [For Open Transaction from Vision Assistant]	//Added By Sainath T On 15-10-2018 [For Open Transaction from Vision Assistant]-START
			$wnd.openTransactionsGWT = $entry(baseE12.@ibase.e12ria.client.BaseE12::openTransactions(Ljava/lang/String;));

			$wnd.openTransactionGWT = $entry(baseE12.@ibase.e12ria.client.BaseE12::openTransaction(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;));
			$wnd.openTransactionPoupupGWT = $entry(baseE12.@ibase.e12ria.client.BaseE12::openTransaction(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;));
			$wnd.openBulletinBoardGWT = $entry(baseE12.@ibase.e12ria.client.BaseE12::openBulletinBoard(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;));
			//$wnd.openWorkflwGWT = $entry(baseE12.@ibase.e12ria.client.BaseE12::openWorkflw(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;));
			//Changed By Suraj added parameter default refId
			$wnd.openWorkFlw = $entry(baseE12.@ibase.e12ria.client.BaseE12::openWorkflw(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;));
			$wnd.loadGWTComponent = $entry(baseE12.@ibase.e12ria.client.BaseE12::loadGWTComponent(Ljava/lang/String;Ljava/lang/String;));
			$wnd.performActionITM = $entry(baseE12.@ibase.e12ria.client.BaseE12::performActionITM(Ljava/lang/String;));

			//Added by Prasad on 02/11/18 [to perform link action]
			//Changed By Pankaj T. on 04-12-18 added link configuration for link_type 3 ("" or 1 - open in side panel, 2 - open separately, 3 - only add in context menu, 4 - only add in side panel)
			$wnd.performLinkAction = $entry(baseE12.@ibase.e12ria.client.BaseE12::performLinkAction(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;));
			//Added by Prathhek on 11-11-19[ to open the actions and links in myTag landing dashboard]-Start
			$wnd.customLog('Calling the export method from BaseE12 2495!!!!');
			$wnd.transInfoExport = $entry(baseE12.@ibase.e12ria.client.BaseE12::callingExportMethod());
			//Added by Prathhek on 11-11-19[ to open the actions and links in myTag landing dashboard]-End
            $wnd.logoutUser = $entry(baseE12.@ibase.e12ria.client.BaseE12::logoutUser()); //Added by Jatin M on 24-Jun-2022 [To export logout method as javascript function] - 
			//Added by shrutika on 26-05-2020 for close panel in case of extract template.
			$wnd.closePopup = $entry(baseE12.@ibase.e12ria.client.BaseE12::closePopup());
		}-*/;
		// Added by Dnyaneshwar chavan on 26-Apr-14 [ Hide the E12Intro popup panel] Start

		//Added by shrutika on 17-07-17 [Start] for Call Report Status menu issue
		public void isDcrExist(String isLastDcr)
		{
			this.isDcrOpen = isLastDcr;
		}
		//Added by shrutika on 17-07-17 [End] for Call Report Status menu issue
		
		//Added by Pratheek on 11-11-19[to open actions and links when click on feeds in myTagging landing dashboard]-Start
		public void callingExportMethod()
		{
			E12CommonUtils.printOnConsole("Inside BaseE12 callingExportMethod 2520!!!!!");
			E12TagActionLinks tagActionLinks = new  E12TagActionLinks();
			tagActionLinks.exportMethod(tagActionLinks);
		}
		//Added by Pratheek on 11-11-19[to open actions and links when click on feeds in myTagging landing dashboard]-ENd

		public static void addCommunicator(E12Communicator communicator)
		{
			communicators.add( communicator );
		}

		public static void updateSeachComponent(String selectedMenu, Command searchCmd)
		{
	        // Notify everybody that may be interested.
	        for (E12Communicator hl : communicators)
	        {
	        	hl.updateCommands(selectedMenu, searchCmd);
	        }
	    }

		private native void removeElementByClassName(String className, boolean removeParent)
		/*-{
			try{
			if( removeParent )
			{
				document.getElementsByClassName( className ).parent().remove();
			}
			else
			{
				document.getElementsByClassName( className ).remove();
			}
			}
			catch(e){
			}
		}-*/;

		public void loadGWTComponent(String actionName, String targetId)
		{
			E12CommonUtils.printOnConsole("Loading component [ " + actionName  + "]["+targetId+"]");
			if( "load_tnc_doc".equalsIgnoreCase(actionName) )
			{
				if("Y".equals( E12Constants.isTNCInitiated ) )
				{
					E12TermsNCondition.getInstance().initTermsNConditions();
				}
			}
		}

		public void performActionITM( String rightChar )
		{
			e12TransBrow.e12TabPanel.performHomepageAction(rightChar);
		}

		public static void invokeAction(String action)
		{
	        // Notify everybody that may be interested.
	        for (E12Communicator hl : communicators)
	        {
	        	hl.invokeAction(action);
	        }
	    }

		public static Widget openTransaction(String action, E12TransInfoObj e12TransInfoObj)
		{
			Widget widget = null;
	        // Notify everybody that may be interested.
	        for (E12Communicator hl : communicators)
	        {
	        	widget = hl.openTransaction(action, e12TransInfoObj);
	        	if( widget != null )
	        	{
	        		break;
	        	}
	        }
	        return widget;
	    }

		//Added by Prasad on 05/02/16 [for Tagging - get all tag values - B15FSUN004] START
		/**
		 * Get All Tag values from server and store in local data
		 */
		private void getAllTagValues()
		{
			try
			{
				E12CommonUtils.printOnConsole("-------getAllTagValues-----------");

				HashMap<String, String> paramMap = new HashMap<String, String>();
				paramMap.put("ACTION", "GET_ALL_TAG_DTL");
				paramMap.put("USER_ID", E12Constants.userID);
				paramMap.put("dummyInt", "" + Math.random());
				//Changes made by Pratheek on 05-09-19[ so to differentiate the action calling from angular comp or not]-Start
				paramMap.put("ANG_COMP", "false");
				//Changes made by Pratheek on 05-09-19[ so to differentiate the action calling from angular comp or not]-End
				String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);
				String path = E12Global.getHostUrl() + "/ibase/WEBITMRIARequestHandlerServlet?" + paramString ;
				HashMap<String, String> requestDataMap = new HashMap<String, String>();
				requestDataMap.put( RequestDataKeys.LOCAL_STORAGE_KEY, E12Constants.userID + "_/ibase/WEBITMRIARequestHandlerServlet?" );

				RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, path);
				requestBuilder.setHeader("Content-Type","application/x-www-form-urlencoded");
				try
				{
					requestBuilder.sendRequest( paramString, new RequestCallback()
					{
						@Override
						public void onResponseReceived(Request request, Response response)
						{
							if( E12Global.getInstance().checkErrorException(response, 1) )
							{
								E12Global.getInstance().setAllTagValues( response.getText() );
							}
						}
						@Override
						public void onError(Request request, Throwable exception)
						{
							Window.alert( "Error" );
						}
					});
				}
				catch ( RequestException ex )
				{
					Window.alert( "RequestException - ["+ ex.getMessage() +"]" );
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		//Added by Prasad on 05/02/16 [for Tagging - get all tag values - B15FSUN004] END
		/*Added by Pankaj R on 19-Jan-17 to show direct panel if only one tab is present [START]*/
		public native void log(Object o)
		/*-{
			$wnd.customLog(o);
		}-*/;
		/*Added by Pankaj R on 19-Jan-17 to show direct panel if only one tab is present [END]*/

		//Added By Pratheek on 28/6/17 [to get event_date]-Start
		public void setWizardParamMap(String qryStr)
		{
			wizardParamMap = new HashMap<String,String>();
			if( !"".equalsIgnoreCase(E12Global.checkNull(qryStr)) )
			{
				String paramStr[] = qryStr.split("&");
				for( int i = 0; i < paramStr.length; i++ )
				{
					String paramKeyValue[] = paramStr[i].split("=");
					String fldName = "Detail1.1."+E12Global.checkNull(paramKeyValue[0]);
					String fldValue = E12Global.checkNull(paramKeyValue[1]);
					String decodVal = URL.decodeQueryString(fldValue);
					wizardParamMap.put( fldName , decodVal);
				}
			}
		}
		//Added By Pratheek on 28/6/17 [to get event_date]-End

		//Added By Pratheek on 28/6/17 [to get MenuId]-Start
		public String getMenuIdInTree(String objName, String objType )
		{
			String menuIdStr = "";
			objName = E12CommonUtils.checkNull(objName);

			E12CommonUtils.printOnConsole("objName[" + objName + "]");
			if( BaseE12.e12MenuPanel.e12TransMenu.tree != null && objName.trim().length() > 0 )
			{
				Iterator<TreeItem> iterator = BaseE12.e12MenuPanel.e12TransMenu.tree.treeItemIterator();
				while (iterator.hasNext())
				{
					E12TreeItem treeItem = (E12TreeItem) iterator.next();
					Object menuObject = treeItem.getUserObject();
					if( menuObject instanceof E12TransInfoObj )
					{
						E12TransInfoObj menuTransObj = (E12TransInfoObj)menuObject;
						String menuTitle = E12CommonUtils.checkNull( menuTransObj.getTitle() );
						E12CommonUtils.printOnConsole("menuTransObj[" + menuTransObj.toString() +"]");
						String currentObjName = menuTransObj.getObjName();
						String currentObjType = menuTransObj.getObjType();
						if( currentObjName.equals( objName ) && currentObjType.equalsIgnoreCase( objType ) )
						{
							menuIdStr = menuTransObj.getId();
						}
					}
				}
			}
			return menuIdStr;
		}
		//Added By Pratheek on 28/6/17 [to get MenuId]-End
		//added by vishal pathare on 1.9.17 for[image icon related issue in wizard]Start.
		public String getMenuIconInTree(String objName, String objType )
		{
			String menuIconStr = "";
			objName = E12CommonUtils.checkNull(objName);

			E12CommonUtils.printOnConsole("objName[" + objName + "]");
			if( BaseE12.e12MenuPanel.e12TransMenu.tree != null && objName.trim().length() > 0 )
			{
				Iterator<TreeItem> iterator = BaseE12.e12MenuPanel.e12TransMenu.tree.treeItemIterator();
				while (iterator.hasNext())
				{
					E12TreeItem treeItem = (E12TreeItem) iterator.next();
					Object menuObject = treeItem.getUserObject();
					if( menuObject instanceof E12TransInfoObj )
					{
						E12TransInfoObj menuTransObj = (E12TransInfoObj)menuObject;
						String menuTitle = E12CommonUtils.checkNull( menuTransObj.getTitle() );
						E12CommonUtils.printOnConsole("menuTransObj[" + menuTransObj.toString() +"]");
						String currentObjName = menuTransObj.getObjName();
						String currentObjType = menuTransObj.getObjType();
						if( currentObjName.equals( objName ) && currentObjType.equalsIgnoreCase( objType ) )
						{
							menuIconStr = menuTransObj.getIcon();
						}
					}
				}
			}
			return menuIconStr;
		}
		//added by vishal pathare on 1.9.17 for[image icon related issue in wizard]End.

		/*Added by Pankaj R on 14-11-17 for enterprise logo [START]*/
		private void setEnterpriseLogo()
		{
			E12CommonUtils.printOnConsole("Inside setEnterpriseLogo() : "+E12Constants.enterprise);

			final String enterprise = E12CommonUtils.checkNull(E12Constants.enterprise);
			E12CommonUtils.printOnConsole("enterprise["+enterprise+"]");
			if( enterprise.trim().length() > 0 )
			{
			    //changed by vishal pathare on 17.4.18 for enteprise image related changes
				E12HeaderPanel.e12Logo.setUrl(E12Global.getHostUrl()+"/ibase/images/"+enterprise+".png");
				//E12HeaderPanel.e12Logo.setUrl("images/"+enterprise+".png");
				E12HeaderPanel.e12Logo.addStyleName("enterpriseLogo");
				E12HeaderPanel.e12Logo.addErrorHandler(new ErrorHandler()
				{
					@Override
					public void onError(ErrorEvent event) {
						E12CommonUtils.printOnConsole("in image onerror : ");
						E12HeaderPanel.e12Logo.setUrl("images/clientLogo.png");

					}
				});
			}
			else
			{
				E12HeaderPanel.e12Logo.setUrl("images/clientLogo.png");
			}
		}
		/*Added by Pankaj R on 14-11-17 for enterprise logo [END]*/

		/*Added by Pravin K  on 19-FEB-18 [to hide social/workflow icon ] START
		 in ibase.xml 'feature' node add  with 'enable' attribute
		 * if the enable = "NO" only then Social or Workflow will hide.
		 * Cases to show the icons(Social or Workflow)
		 * 1> If feature node added
		 * 2> If feature node added with enable='YES'
		 * 3> If feature node not added
		 */
		private void hideFeatures()
		{
			//Added by Pooja S on 21-August-2019 [To show the Developer Console option only to the userType of D(Developer) ] Start
			if(!E12Constants.userType.equalsIgnoreCase("D"))
			{
				E12CommonUtils.printOnConsole("set visible false in case of other user devloperConsole");
				E12HeaderPanel.devloperConsole.getElement().getParentElement().getStyle().setDisplay(Display.NONE);
			}
			//Added by Pooja S on 21-August-2019 [To show the Developer Console option only to the userType of D(Developer) ] End
			if(E12Constants.featureOptions.contains(":NO"))
			{
				String[] featursArr = E12Constants.featureOptions.split("~");
				for(String feature:featursArr)
				{
					if( feature.contains("S:") && feature.contains(":NO") )
					{
						E12CommonUtils.printOnConsole(" Hiding social :"+feature);
						if(E12HeaderPanel.social.getElement()!= null)
						{
							E12HeaderPanel.social.getElement().getParentElement().getStyle().setDisplay(Display.NONE);
						}
						else
						{
							E12CommonUtils.printOnConsole("Social element is null");
						}
					}
					if( feature.contains("W:") && feature.contains(":NO") )
					{
						E12CommonUtils.printOnConsole(" Hiding workflow :"+feature);
						if(E12HeaderPanel.workflow.getElement()!= null)
						{
							E12HeaderPanel.workflow.getElement().getParentElement().getStyle().setDisplay(Display.NONE);
						}
						else
						{
							E12CommonUtils.printOnConsole("Workflow element is null");
						}
					}
				}

			}
		}
		// Added by Pravin K  on 19-FEB-18 [to hide social/workflow icon] END
		public void openFavouriteMenuTransaction( TreeItem item )
		{
			try
			{
				if(( item != null ) && ( item.getChildCount() == 0 ) )
				{
					//Changes made by Pratheek on 23-04-19[ to get the select menu for adding and removing the style of favourite button]-Start
					E12TransInfoObj e12TransInfoObj = ( E12TransInfoObj ) ( item.getUserObject() );
					//Changes made by Pratheek on 23-04-19[ to get the select menu for adding and removing the style of favourite button]-End
					if( lastSelectedExplItem != null )
					{
						lastSelectedExplItem.removeClassName("menuSelected-"+E12ApplicationMenuBar.getApplColor() );
					}
					//Changes made by Pratheek on 23-04-19[ to get the select menu for adding and removing the style of favourite button]-Start
					if( DOM.getElementById("FavMenuButton"+e12TransInfoObj.getId()) != null)
					{
						DOM.getElementById("FavMenuButton"+e12TransInfoObj.getId()).removeClassName("selectedMoreButton");
					}
					//Changes made by Pratheek on 23-04-19[ to get the select menu for adding and removing the style of favourite button]-End
					com.google.gwt.dom.client.NodeList<com.google.gwt.dom.client.Node> nodeList = item.getElement().getChildNodes();
					if( nodeList !=null && nodeList.getLength() > 0 )
					{
						Element element = nodeList.getItem(0).cast();
						if( element != null )
						{
							element.addClassName("menuSelected-"+E12ApplicationMenuBar.getApplColor() );
							lastSelectedExplItem = element;
						}
					}
					//Changes made by Pratheek on 23-04-19[ to get the select menu for adding and removing the style of favourite button]-Start
					if( DOM.getElementById("FavMenuButton"+e12TransInfoObj.getId()) != null)
					{
						DOM.getElementById("FavMenuButton"+e12TransInfoObj.getId()).addClassName("selectedMoreButton");
					}
					//Changes made by Pratheek on 23-04-19[ to get the select menu for adding and removing the style of favourite button]-End
					openTransaction(e12TransInfoObj);
				}
				else if( item != null )
				{
					if( lastSelectedExplItem != null )
					{
						lastSelectedExplItem.removeClassName("menuSelected-"+E12ApplicationMenuBar.getApplColor() );
					}
					com.google.gwt.dom.client.NodeList<com.google.gwt.dom.client.Node> nodeList = item.getElement().getChildNodes();
					if( nodeList!=null && nodeList.getLength() > 0 )
					{
						Element element = nodeList.getItem(0).cast();
						if( element != null )
						{
							com.google.gwt.dom.client.Node chNode = element.getChild(0);
							if( chNode != null && chNode.getFirstChild() != null && chNode.getFirstChild().getChildCount() >= 2 )
							{
								com.google.gwt.dom.client.Node tNode = chNode.getFirstChild().getChild(1).getFirstChild();
								Element treeDiv = tNode.cast();
								treeDiv.addClassName("menuSelected-"+E12ApplicationMenuBar.getApplColor());
								lastSelectedExplItem = treeDiv;
								if(item.getState())
								{
									treeDiv.removeClassName("upArrow");
								}
								else
								{
									treeDiv.addClassName("upArrow");
								}
							}
						}
					}
					item.setState(!item.getState());
				}
				else
				{
					E12CommonUtils.printOnConsole("Inisde openFavouriteMenuTransaction  item == null item[" +  item + "]");
				}
			}
			catch (Exception e)
			{
				E12CommonUtils.printOnConsole( "Exception :: openFavouriteMenuTransaction When select the Favourite tree ["+e.getMessage()+"]");
				e.printStackTrace();
			}
		}
	//Added By kamal on Jun 14 2019 [To Redirect to dashboard on click based on tabId]Start
		public void selectTab(String pageId) 
		{
			E12CommonUtils.printOnConsole("CustomTabLayoutWidget["+custTabLayoutWidget+"]");
			if( custTabLayoutWidget != null )
			{
				try
				{
					custTabLayoutWidget.selectTab( Integer.parseInt(pageId) - 1 );
				}
				catch(Exception e)
				{
					custTabLayoutWidget.selectTab(0);
					E12CommonUtils.printOnConsole( "Exception :: selectTab ["+e.getMessage()+"]");
					e.printStackTrace();
				}
			}
		}
	//Added By kamal on Jun 14 2019 [To Redirect to dashboard on click based on tabId]End
	//Added by shrutika on 26-05-2020 [Start] for close panel in case of extract template.
	public void closePopup()
	{
		if( E12CommonUtils.getInstance().getPopUpContainer() != null )
		 {
			 E12CommonUtils.getInstance().getPopUpContainer().closePopUp();
		 }
	}
	//Added by shrutika on 26-05-2020 [End] for close panel in case of extract template.
	
	//Added by Pankaj T. on 16-07-20202 for removing vulnerability of Insecure password Storage - start
	private void setPwdSHA256() 
	{
		try 
		{
			HashMap<String, String> paramMap = new HashMap<String, String>();
			paramMap.put("ACTION", "GET_USER_DTL");
			paramMap.put("USER_ID", E12Constants.userID);
			paramMap.put("dummyInt", "" + Math.random());
			String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);
			String path = E12Global.getHostUrl() + "/ibase/WEBITMRIARequestHandlerServlet?";// + paramString ;
			
			RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, path);
			requestBuilder.setHeader("Content-Type","application/x-www-form-urlencoded");
			requestBuilder.sendRequest( paramString, new RequestCallback() 
			{
				@Override
				public void onResponseReceived(Request request, Response response) 
				{
					E12CommonUtils.printOnConsole("In BaseE12.java Response of action GET_USER_DTL:["+response.getText()+"]");
					E12Constants.passwordSha256 = response.getText();
				}
				@Override
				public void onError(Request request, Throwable exception) 
				{
					E12CommonUtils.printOnConsole("In GET_USER_DTL error");
				}
			});
		}
		catch (Exception e) 
		{
			E12CommonUtils.printOnConsole("In BaseE12.java Exception in action GET_USER_DTL : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
	}
	//Added by Pankaj T. on 16-07-20202 for removing vulnerability of Insecure password Storage - end
	
	
	//Added By Nilesh from the anguler we called this method to pass the paramter Start :: 08-02-2021
	
	public void openTransaction(String id, String objName, String objType, String title ,String campId, String brandCode)
	{
		E12CommonUtils.printOnConsole(" 3113 campId ["+campId+"]  code ["+brandCode+"] " );
		E12TransInfoObj e12TransInfoObj = ObjDetails.get(objName).getE12TransInfoObj();
		if( e12TransInfoObj == null )
		{
			String menuIcon = getMenuIconInTree( objName, objType );
			E12CommonUtils.printOnConsole(" menuIcon ["+menuIcon+"]" );
			e12TransInfoObj = new E12TransInfoObj(E12Global.checkNull(id), E12Global.checkNull( menuIcon ), E12Global.checkNull(title), E12Global.checkNull(objName), E12Global.checkNull(objType), "");
			ObjDetails.get(objName).setE12TransInfoObj(e12TransInfoObj);
		}
		
		//e12HeaderPanel.e12ApplicationMenuBar.selectApplication("HOME_OPT");
		openTransaction( e12TransInfoObj ,campId,brandCode  );
	}
	
	public void openTransaction( E12TransInfoObj e12TransInfoObj, String campId, String brandCode )
	{
		try
		{
			E12CommonUtils.printOnConsole( "BaseE12 openTransaction"+brandCode );
			// added by mahesh saggam on 16-OCT-19 [to add poppanel which slides in and out the menupanel on maximize] Start
			if(E12AltHeader.homePopupPnl.getElement() != null && E12SearchBar.hideMenuBtn.isDown() && E12AltHeader.mainVPnl.getWidgetCount() == 2)
			{
				E12AltHeader.homePopupPnl.getElement().setAttribute("style", "width: 270px");
				if(DOM.getElementById("mainMenusFlowPnl") != null)
				{
					DOM.getElementById("mainMenusFlowPnl").setAttribute("style", "width: 270px");
				}
			}
			// added by mahesh saggam on 16-OCT-19 [to add poppanel which slides in and out the menupanel on maximize] End
			 // added by mahesh saggam on 10-OCT-19 [to add poppanel which slides in and out the menupanel on maximize]
			E12AltHeader.homePopupPnl.hide(); 
			if( e12TransInfoObj != null )
			{
				//Changed By Suraj on 14-12-2016 [For menu restriction]Start
				if( !"true".equalsIgnoreCase( e12TransInfoObj.getRestrictValue() ) )
				{
					String title = e12TransInfoObj.getTitle();
					//Modified by Jatin M on 21-04-2022 [Exception thrown when trim() is called] - START
					String menuIdStr = e12TransInfoObj.getId();//.trim();//Like SFA.1.0.0.0.0
					menuIdStr = (""+menuIdStr).trim();
					//Modified by Jatin M on 21-04-2022 [Exception thrown when trim() is called] - END
					String tranObjName = e12TransInfoObj.getObjName();
					E12Constants.objName = e12TransInfoObj.getObjName();
					E12Global.getInstance().addObjName(E12Constants.objName);
					E12Constants.objTitle = e12TransInfoObj.getTitle();
					E12Global.getInstance().addObjTitle(E12Constants.objTitle);
					E12Global.getInstance().getObjFormInfo().put(E12Constants.objTitle, E12Constants.objName);
					//Added by shrutika on 18-01-19 [Start] for getting objname on click of close tab for remove user activities.
					String menuIdStrkey = menuIdStr.replace(".", "_");
					E12Global.getObjFormInfo().put(menuIdStrkey, E12Constants.objName);
					//Added by shrutika on 18-01-19 [End] for getting objname on click of close tab for remove user activities.
					//Added By Pratheek on 28/6/17[if menuId comes blank and pass the id to set in TransInfoObj]-Start
					if("".equalsIgnoreCase(menuIdStr) )
					{
						menuIdStr = getMenuIdInTree(tranObjName,e12TransInfoObj.getObjType());
						e12TransInfoObj.setId(menuIdStr);
					}
					//Added By Pratheek on 28/6/17[if menuId comes blank and pass the id to set in TransInfoObj]-End
					E12CommonUtils.printOnConsole("Setting toSelectItemID as [" + menuIdStr + "] On click of [" + title+"] tranObjName ["+tranObjName+"] objType ["+e12TransInfoObj.getObjType()+"]");
					//Added By Pankaj T on 04-05-18 for disable feed on click of action - Start
					E12Global.getInstance().getPanelLabelMap().clear();
					//Added By Pankaj T on 04-05-18 for disable feed on click of action - End
					BaseE12.e12MenuPanel.e12TransMenu.toSelectItemID = menuIdStr;
					//Added By Ajinkya Gopalkar on 2-DEC-15[for maximize screen option on menu selection]
					String defValueOption = e12TransInfoObj.getDefValueOpt();
					if(defValueOption !=null && "1".equalsIgnoreCase( defValueOption ))
					{
						BaseE12.invokeAction("maximize");
					}
					//Suraj temp added to test
					E12CommonUtils.getInstance().setE12TransInfoObj(e12TransInfoObj);

					E12Constants.objName = e12TransInfoObj.getObjName();
					E12Constants.objTitle = e12TransInfoObj.getTitle();
					E12Constants.objType = e12TransInfoObj.getObjType();

					//Added by shrutika on 20-07-17 [Start] for second time dcr is not open on Call Report Status menu issue
					if("true".equalsIgnoreCase(isDcrOpen))
					{
						E12Global.getInstance().setMyCircleClick(true);
					}
					else
					{
						E12Global.getInstance().setMyCircleClick(false);
					}
					//Added by shrutika on 20-07-17 [End] for second time dcr is not open on Call Report Status menu issue
					/**
					 * Depending upon following object type it will generate random ID.
					 */
					if( e12TransInfoObj.getObjType().equalsIgnoreCase( "I" ) || e12TransInfoObj.getObjType().equalsIgnoreCase( "L" ) || e12TransInfoObj.getObjType().equals( "W" ) || e12TransInfoObj.getObjType().equals( "Z" ) || e12TransInfoObj.equals("R") || e12TransInfoObj.equals("C") || e12TransInfoObj.equals("D") || e12TransInfoObj.getObjType().equals( "A" ) || e12TransInfoObj.equals("E") || e12TransInfoObj.getObjType().equals("M") || e12TransInfoObj.getObjType().equals("S")  || e12TransInfoObj.getObjType().equals("H") || e12TransInfoObj.getObjType().equalsIgnoreCase( "P" )|| e12TransInfoObj.getObjType().equalsIgnoreCase( "J" ) || e12TransInfoObj.getObjType().equalsIgnoreCase( "V" ) )
					{
						String mapId = E12Constants.userID + menuIdStr;
						String randomID = E12Constants.userID + generateRandomNo();

						instanceIdStr = null;
						instanceIdStr = randomID;
						E12CommonUtils.printOnConsole( "openTransaction tabsMap["+tabsMap.toString()+"]" );
						if( ! tabsMap.containsKey( mapId ) )
						{
							tabsMap.put( mapId, randomID );
						}
						else
						{
							int e12TabCount = e12TransBrow.e12TabPanel.getWidgetCount();
							int tabToRemove = -1;
							//Added by Prasad on 03/05/18 [open existing selected menu's]
							boolean flag = false;
							for ( int i = 1; i < e12TabCount; i++ )
							{
								final VerticalPanel e12PnlGenWidget = ( VerticalPanel ) ( BaseE12.e12TransBrow.e12TabPanel.getWidget( i ) );
								if ( e12PnlGenWidget.getWidgetCount() >= 2 )
								{
									TextBox tbID = ( TextBox ) e12PnlGenWidget.getWidget( 1 );
									if( menuIdStr.equalsIgnoreCase( tbID.getText() ) )
									{
										tabToRemove = i;
										//Added by Prasad on 03/05/18 [open existing selected menu's]
										e12TransBrow.e12TabPanel.selectTab(tabToRemove);
										flag = true;
										//Added by Sagar M. on 02/11/18 [Removing and adding local js each time on menu click]Start
										E12CommonUtils.printOnConsole("BaseE12 inside remove js file objname ["+e12TransInfoObj.getObjName()+"]");
										E12CommonUtils.getInstance().removeJSFile(e12TransInfoObj.getObjName(), "js");
									    E12CommonUtils.printOnConsole("BaseE12 inside include jsfileName------"+e12TransInfoObj.getObjName());
										String jsFilePath = E12Global.getHostUrl() + "/ibase/webitm/js/"+e12TransInfoObj.getObjName()+".js";
										E12CommonUtils.getInstance().includeJSFile(jsFilePath);
										//Added by Sagar M. on 02/11/18 [Removing and adding local js each time on menu click]End
										break;
									}
								}
							}
							//Changes By Prajyot on 24-08-2011 [ To restrict user from opening more than 12 Tabs ] Starts
							//Added by Prasadon 03/05/18 [open existing selected menu's] START
							//e12TransBrow.e12TabPanel.selectTab(tabToRemove);
							if( flag == true )
							{
								return;
							}
							//Added by Prasad on 03/05/18 [open existing selected menu's] END
						}
					}

					String objType = e12TransInfoObj.getObjType();
					isWidgetPresent = false;
					/**
					 * It will check the object type. Depending upon the object type it will called respective panel.
					 */
					
					if( objType.equals("G") || objType.equals("T") || objType.equals("P") ||  objType.equals("W") || objType.equals("I") || objType.equals("L") || objType.equals("F") || objType.equals("Z") || objType.equals("R") || objType.equals("C") || objType.equals("D") || objType.equals("A") || objType.equals("E") || objType.equals("M") || objType.equals("S") || objType.equals("H") || objType.equals("J") || objType.equals("V"))
					{
						int e12TabCount = e12TransBrow.e12TabPanel.getWidgetCount();
						//Changes By Prajyot on 24-08-2011 [ To restrict user from opening more than 12 Tabs ] Starts
						/**
						 * Check for 12 tab open in RIALite.
						 * If 12 tab is open it cannot allow to open new tab.
						 */
						if( e12TabCount > 12 )
						{
							boolean flag = false;
							for ( int i = 1; i < e12TabCount; i++ )
							{
								final VerticalPanel e12PnlGenWidget = ( VerticalPanel ) ( BaseE12.e12TransBrow.e12TabPanel.getWidget( i ) );
								if ( e12PnlGenWidget.getWidgetCount() >= 2  )
								{
									TextBox tbID = ( TextBox ) e12PnlGenWidget.getWidget( 1 );
									if( menuIdStr.equalsIgnoreCase( tbID.getText() ) )
									{
										e12TransBrow.e12TabPanel.selectTab(i);
										flag = true;
										//Added by Sagar M. on 02/11/18 [Removing and adding local js each time on menu click]Start
										E12CommonUtils.printOnConsole("BaseE12 inside remove js file objname ["+e12TransInfoObj.getObjName()+"]");
										E12CommonUtils.getInstance().removeJSFile(e12TransInfoObj.getObjName(), "js");
									    E12CommonUtils.printOnConsole("BaseE12 inside include jsfileName------"+e12TransInfoObj.getObjName());
										String jsFilePath = E12Global.getHostUrl() + "/ibase/webitm/js/"+e12TransInfoObj.getObjName()+".js";
										E12CommonUtils.getInstance().includeJSFile(jsFilePath);
										//Added by Sagar M. on 02/11/18 [Removing and adding local js each time on menu click]End
									}
								}
							}
							if( flag == true )
							{
								return;
							}
							else
							{
								//Window.alert( moreThan12 );
								// Added by Reema on 28-Oct-14 [Remove earlieast tab if TabCount exceed than 12 as per Kandarp sir]
								int lastTabCount = e12TabCount - 1;
								String lastTab = e12TransBrow.e12TabPanel.getTabTitle(lastTabCount);;
								E12CommonUtils.printOnConsole("LastTab: "+lastTab);
								closeTab();
						        BaseE12.e12TransBrow.e12TabPanel.remove( lastTabCount );
						        E12CommonUtils.printOnConsole("lastTabCount "+lastTabCount);
						        for ( int i = 1; i < lastTabCount; i++ )
								{
						        	
						        	final VerticalPanel e12PnlGenWidget = ( VerticalPanel ) ( BaseE12.e12TransBrow.e12TabPanel.getWidget( i ) );
									HorizontalPanel horzPanel = new HorizontalPanel();
									VerticalPanel newE12PnlGenWidget = new VerticalPanel();
									//Changes made by Pratheek on 20-08-18[on second time when click on menu server call was getting call to load homepage ]-Start
									if( e12PnlGenWidget.getWidgetCount() > 0 )
									//Changes made by Pratheek on 20-08-18[on second time when click on menu server call was getting call to load homepage ]-End
									{
										if( e12PnlGenWidget.getWidget(0) instanceof HorizontalPanel )
										{
											horzPanel = (HorizontalPanel) e12PnlGenWidget.getWidget(0);
											if( horzPanel.getWidget(0) instanceof VerticalPanel )
											{
												newE12PnlGenWidget = (VerticalPanel) horzPanel.getWidget(0);
											}
										}
									}
									if( newE12PnlGenWidget != null && newE12PnlGenWidget.getWidgetCount() > 1 )
									{
										if ( newE12PnlGenWidget.getWidgetCount() >= 2  )
										{
											TextBox tbID = ( TextBox ) newE12PnlGenWidget.getWidget( 1 );
											if( menuIdStr.equalsIgnoreCase( tbID.getText() ) )
											{
												//Added by Shrutika on 17-07-17 [Start] for Call Report Status menu issue
												if("true".equalsIgnoreCase( isDcrOpen ))
												{
													e12TransBrow.e12TabPanel.remove(i);
													isWidgetPresent = false;
													isDcrOpen = "false";
												}
												else
												{
													e12TransBrow.e12TabPanel.selectTab(i);
													isWidgetPresent = true;
													//Added by Sagar M. on 02/11/18 [Removing and adding local js each time on menu click]Start
													E12CommonUtils.printOnConsole("BaseE12 inside remove js file objname ["+e12TransInfoObj.getObjName()+"]");
													E12CommonUtils.getInstance().removeJSFile(e12TransInfoObj.getObjName(), "js");
												    E12CommonUtils.printOnConsole("BaseE12 inside include jsfileName------"+e12TransInfoObj.getObjName());
													String jsFilePath = E12Global.getHostUrl() + "/ibase/webitm/js/"+e12TransInfoObj.getObjName()+".js";
													E12CommonUtils.getInstance().includeJSFile(jsFilePath);
													//Added by Sagar M. on 02/11/18 [Removing and adding local js each time on menu click]End
												}
												//Added by shrutika on 17-07-17 [End] for Call Report Status menu issue
//											e12TransBrow.e12TabPanel.selectTab(i);
//											isWidgetPresent = true;
											}
										}
									}
									//Changed by Sandeep S. on 23-02-17 End
								}

						        E12CommonUtils.printOnConsole("Inside BassE12 1263 isWidgetPresent!!!!!!"+isWidgetPresent +"]");
								if( isWidgetPresent == false )
								{
									if( objType.equals( "W" ) || objType.equals( "Z" ) )
									{
										
										E12PopupContainer popContainer = new E12PopupContainer();
										//Added by Pooja S on 7-NOVEMBER-2019 [To set the popupContrainer]
										E12CommonUtils.getInstance().setPopUpContainer(popContainer);
										//E12SidePanelContainers e12SidePanelContainers = new E12SidePanelContainers(e12TransInfoObj, instanceIdStr, callerInterface, null);
										E12SidePanelContainers e12SidePanelContainers = new E12SidePanelContainers(e12TransInfoObj, instanceIdStr, callerInterface, true,"A",popContainer,null,campId,brandCode);
										VerticalPanel vPanel = (VerticalPanel) e12SidePanelContainers.getWidget();
										vPanel.setStyleName("tabContentPanel");
										popContainer.openWidget(vPanel);
										e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, title);
										//changed by parikshit on 29/12/16 [to add side panel] end
										e12TransBrow.e12TabPanel.selectTab( 1 );
									}
									else if( objType.equals("T") )
									{
										//Added by shrutika on 18-01-19 [Start] for getting first widget on click of close tab for remove user activities.
										TextBox tabIdTxtBx = new TextBox();
										tabIdTxtBx.setText(menuIdStr);
										tabIdTxtBx.setVisible( false );
										tabIdTxtBx.setHeight("0px");
										//Added by shrutika on 18-01-19 [End] for getting first widget on click of close tab for remove user activities.
										//changed by parikshit on 29/12/16 [to add side panel] start
										/*E12HomePage e12HomePage = new E12HomePage();
										VerticalPanel vPanel =  e12HomePage.createE12HomePage( e12TransInfoObj, menuIdStr );*/
										E12SidePanelContainers e12SidePanelContainers = new E12SidePanelContainers(e12TransInfoObj, instanceIdStr, callerInterface, null);
										VerticalPanel vPanel =  e12SidePanelContainers.getWidget();
										vPanel.setStyleName("tabContentPanel");

										//Added by shrutika on 18-01-19 [Start] for getting first widget on click of close tab for remove user activities.
										vPanel.add(tabIdTxtBx);
										e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, e12SidePanelContainers.e12HomePage, title, "");
										//changed by parikshit on 29/12/16 [to add side panel] end
										e12TransBrow.e12TabPanel.selectTab(1);
									}
									//Added By UMAKANTA On 12/FEB/2015 [ For display report through Browser Interface ] Start
									else if( objType.equals("R") )
									{
										//Changed by Prasad on 02/11/17 [implementation of side panel for report] START
										E12SidePanelContainers e12SidePanelContainers = new E12SidePanelContainers(e12TransInfoObj, instanceIdStr, callerInterface, null);
										//E12Report e12Report = new E12Report( e12TransInfoObj );
										TextBox tabIdTxtBx = new TextBox();
										tabIdTxtBx.setText(menuIdStr);
										tabIdTxtBx.setVisible( false );
										tabIdTxtBx.setHeight("0px");

										//VerticalPanel vTabPanel =  new VerticalPanel();
										VerticalPanel vTabPanel =  e12SidePanelContainers.getWidget();
										//vTabPanel.add(e12Report);
										//Added by Prasad on 02/11/17 [implementation of side panel for report] END
										vTabPanel.add( tabIdTxtBx );
										//vTabPanel.setStylePrimaryName( "mainPage-Container" );
										// added mahesh saggam on 10-OCT-19 [to add poppanel which slides in and out the menupanel on maximize]
										vTabPanel.setStyleName("reportTabContentPanel");
										e12TransBrow.e12TabPanel.insert( vTabPanel, getTabWidget( vTabPanel, title ), 1);
										e12TransBrow.e12TabPanel.selectTab(1);
									}//Added By UMAKANTA On 12/FEB/2015 [ For display report through Browser Interface ] End
									else if( objType.equals("G") )
									{
										VerticalPanel vPanel =  new E12TransPanelGenerator().createE12TransPanel( e12TransInfoObj );
										vPanel.setStyleName("tabContentPanel");
										e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, title);
										e12TransBrow.e12TabPanel.selectTab(1);
									}
									//Added by Pratheek on 25-05-18[to call the process screen same as wizard]-Start
									else if( objType.equals("P") )
									{
										if(instanceIdStr == null)
										{
											instanceIdStr = E12Constants.userID + generateRandomNo();;
										}
//										
										E12SidePanelContainers e12SidePanelContainers = new E12SidePanelContainers(e12TransInfoObj, instanceIdStr, callerInterface, null);
										E12CommonUtils.printOnConsole("menuIdStr 1663!!!!!{"+menuIdStr+"}");
										VerticalPanel vPanel =  e12SidePanelContainers.getWidget();

										vPanel.setStylePrimaryName( "tabContentPanel" );
										e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, title);
										e12TransBrow.e12TabPanel.selectTab( 1 );
										if(E12Global.isGalaxy())
										{
											((Element) vPanel.getElement().getFirstChild().getChild(1)).setAttribute("style", "height: 0px;");
										}
									}
									//Added by Pratheek on 25-05-18[to call the process screen same as wizard]-End
									//Added By Prasad on 15/06/15 [to add E (for Document Upload with Transaction)] START
									else if( objType.equals("E") )
									{
										VerticalPanel vPanel;
										if ( e12TransInfoObj.getObjName().indexOf("/") != -1 )
										{
											vPanel = ( VerticalPanel ) ( new E12PanelGenerator().createE12TransPanel( e12TransInfoObj, instanceIdStr ) );
											e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, title);
										}
										else
										{
											E12HomePage e12HomePage = new E12HomePage();
											vPanel =  e12HomePage.createE12HomePage( e12TransInfoObj, menuIdStr );
											e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, e12HomePage, title, "");
										}
										vPanel.setStyleName("tabContentPanel");
										e12TransBrow.e12TabPanel.selectTab(1);
									}
									//Added By Prasad on 15/06/15 [to add E (for Document Upload with Transaction)] END
									else if( objType.equals("C") || objType.equals("M"))
									{
										if(instanceIdStr == null)
										{
											instanceIdStr = E12Constants.userID + generateRandomNo();;
										}
										//Changed By Suraj on 19-01-2017 [To set objName on tab selection]Start
										E12PanelGenerator e12PanelGenerator = new E12PanelGenerator();
										VerticalPanel vPanel = ( VerticalPanel ) ( e12PanelGenerator.createE12TransPanel( e12TransInfoObj, instanceIdStr ) );
										vPanel.setStylePrimaryName( "tabContentPanel" );
										//e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, title);
										e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, e12PanelGenerator, title, menuIdStr.replace(".", "_"));
										//Changed By Suraj on 19-01-2017 [To set objName on tab selection]End
										e12TransBrow.e12TabPanel.selectTab(1);
										((Element) vPanel.getElement().getFirstChild().getChild(1)).setAttribute("style", "height: 0px;");
									}
									//Added by Savita Yadav on 18-05-2015 [For Bulk delete attachment] - Start
									else if( objType.equals("D") )
									{
										VerticalPanel vPanel =  new E12BulkDelete().createSearchPanel(e12TransInfoObj);
										vPanel.setStyleName("tabContentPanel");
										e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, title);
										e12TransBrow.e12TabPanel.selectTab(1);
									}
									//Added by Savita Yadav on 18-05-2015 [For Bulk delete attachment] - End
									//Added By Prashant Chavan  on 26-Aug-15 [ For Survey] START
									else if( objType.equals("S") )
									{
										E12Survey e12Survey = new E12Survey( e12TransInfoObj );
										VerticalPanel vTabPanel =  new VerticalPanel();
										vTabPanel.add(e12Survey);
										vTabPanel.setStylePrimaryName( "mainPage-Container" );
										e12TransBrow.e12TabPanel.insert( vTabPanel, getTabWidget( vTabPanel, title ), 1);
										e12TransBrow.e12TabPanel.selectTab(1);
									}
									//Added By Prashant Chavan  on 26-Aug-15 [ For Survey] END
									//Added by Chetan Mahajan on 08-09-2015 [For Workflow pending transaction Req id : W15FSUN005] - Start
									else if( objType.equals("H") )
									{
										WFPRCDataView e12workflowstatus = new WFPRCDataView(e12TransInfoObj);
										VerticalPanel vTabPanel = new VerticalPanel();
										vTabPanel.add(e12workflowstatus);
										vTabPanel.setStylePrimaryName( "mainPage-Container" );
										e12TransBrow.e12TabPanel.insert( vTabPanel, getTabWidget( vTabPanel, title ), 1);
										e12TransBrow.e12TabPanel.selectTab(1);
									}
									//Added by Chetan Mahajan on 08-09-2015 [For Workflow pending transaction Req id : W15FSUN005] - End
									//Added By Prajyot Rumde on 19-JUN-18 [ For Dashboard Load From Menu for objType A] START
									else if( objType.equals("A") )
									{
										// Changed  by Pravin K on 27-NOV-19 [For message notification] START
										if("message_comp".equalsIgnoreCase( E12Constants.objName) ) 
										{
											
											E12CommonUtils.printOnConsole("0: Notification component ");
											
											VerticalPanel notificationScrPanel = new VerticalPanel();
											
											NotificationPanel notificationPanel = new NotificationPanel();
											notificationScrPanel.add(notificationPanel.getAddUI());
											notificationScrPanel.setStyleName("notificatinScrollPanel");
											
											notificationScrPanel.getElement().setAttribute("data-tab-id", menuIdStr);
											e12TransBrow.e12TabPanel.insert(notificationScrPanel, getTabWidget( notificationScrPanel, title ), 1);
											e12TransBrow.e12TabPanel.selectTab(1);
										}
										else
										{
											E12ANGReport angReport = new E12ANGReport(e12TransInfoObj);
											VerticalPanel vTabPanel =  new VerticalPanel();
											E12CommonUtils.printOnConsole("objType and for A objType angReport IN !!!!!{"+objType+"}["+ angReport + "]");
											vTabPanel.add(angReport);
											
											TextBox tbID = new TextBox();
											tbID.setText( e12TransInfoObj.getId() );
											tbID.setVisible( false );
											vTabPanel.add( tbID );
											
											vTabPanel.setStylePrimaryName( "mainPage-Container" );
											e12TransBrow.e12TabPanel.insert( vTabPanel, getTabWidget( vTabPanel, title ), 1);
											e12TransBrow.e12TabPanel.selectTab(1);
										}
										// Changed  by Pravin K on 27-NOV-19 [For message notification] END
									}
									//Added By Prajyot Rumde on 19-JUN-18 [ For Dashboard Load From Menu for objType A] END
									//Added By Shrutika N. on 16-12-2020 added new obj_type j to open angular component for incentive process to show a processid according to win_name - start
									else if( objType.equals("J") ) 
									{
										E12CommonUtils.printOnConsole("inside objType j.............1765");
										
										VerticalPanel vTabPanel =  new VerticalPanel();
										final String targetId = "generalized_process";
										
										String objName = e12TransInfoObj.getObjName();
										E12CommonUtils.printOnConsole("inside objType j.............1777"+objName);
										
										final JSONObject configData = new JSONObject();
										configData.put("componentName", new JSONString(targetId));
										configData.put("targetId", new JSONString(targetId));
										configData.put("OBJ_NAME", new JSONString(objName));
										
										E12CommonUtils.printOnConsole("inside objType j.............1784"+configData.toString());
										
										E12AngularComponent e12AngularComponent = new E12AngularComponent( targetId , configData.toString() );
										vTabPanel.add(e12AngularComponent);
										
										TextBox tbID = new TextBox();
										tbID.setText( e12TransInfoObj.getId() );
										tbID.setVisible( false );
										vTabPanel.add( tbID );
										vTabPanel.setStylePrimaryName( "mainPage-Container" );
										e12TransBrow.e12TabPanel.insert( vTabPanel, getTabWidget( vTabPanel, title ), 1);
										e12TransBrow.e12TabPanel.selectTab(1);
									}
									//Added By Shrutika N. on 16-12-2020 added new obj_type j to open angular component for incentive process to show a processid according to win_name - end
									//Added By nikhil on 23-02-2022 added new obj_type v to open angular component for shared visual to show a processid according to win_name [Start]
									else if( objType.equals("V") ) 
									{
										E12CommonUtils.printOnConsole("inside objType v.............3825");
										
										VerticalPanel vTabPanel =  new VerticalPanel();
										final String targetId = "dash_def";
										
										String objName = e12TransInfoObj.getObjName();
										E12CommonUtils.printOnConsole("inside objType v.............3831"+objName);
										
										final JSONObject configData = new JSONObject();
										configData.put("componentName", new JSONString(targetId));
										configData.put("targetId", new JSONString(targetId));
										configData.put("OBJ_NAME", new JSONString(objName));
										
										E12CommonUtils.printOnConsole("inside objType v.............3838"+configData.toString());
										
										E12AngularComponent e12AngularComponent = new E12AngularComponent( targetId , configData.toString() );
										vTabPanel.add(e12AngularComponent);
										
										TextBox tbID = new TextBox();
										tbID.setText( e12TransInfoObj.getId() );
										tbID.setVisible( false );
										vTabPanel.add( tbID );
										vTabPanel.setStylePrimaryName( "mainPage-Container" );
										e12TransBrow.e12TabPanel.insert( vTabPanel, getTabWidget( vTabPanel, title ), 1);
										e12TransBrow.e12TabPanel.selectTab(1);
									}
									//Added By nikhil on 23-02-2022 added new obj_type v to open angular component for shared visual to show a processid according to win_name [End]
									else
									{
										if(instanceIdStr == null)
										{
											instanceIdStr = E12Constants.userID + generateRandomNo();;
										}
										VerticalPanel vPanel = ( VerticalPanel ) ( new E12PanelGenerator().createE12TransPanel(e12TransInfoObj, instanceIdStr ) );
										vPanel.setStyleName("tabContentPanel");
										e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, title);
										e12TransBrow.e12TabPanel.selectTab( 1 );
									}
								}


							}
						}

						/**
						 * If tab is already present into tabpanel then it remove first & create it on first tab position.
						 * Otherwise create new tab on first position.
						 */
						else
						{
							//Added by shrutika on 18-01-19 [Start] for getting objname on click of close tab for remove user activities.
							String mapId = E12Constants.userID + menuIdStr + "_" + "OBJ_NAME";
							if( ! tabsMap.containsKey( mapId ) )
							{
								E12CommonUtils.printOnConsole("inside opentransaction.....1668");
								tabsMap.put( mapId, E12Constants.objName );
							}
							//Added by shrutika on 18-01-19 [End] for getting objname on click of close tab for remove user activities.
							E12CommonUtils.printOnConsole("BaseE12 : 1399 e12TabCount ["+e12TabCount+"]");
							for ( int i = 1; i < e12TabCount; i++ )
							{
								//Changed by Sandeep S. on 23-02-17 Start
								final VerticalPanel e12PnlGenWidget = ( VerticalPanel ) ( BaseE12.e12TransBrow.e12TabPanel.getWidget( i ) );
								HorizontalPanel horzPanel = new HorizontalPanel();
								VerticalPanel newE12PnlGenWidget = new VerticalPanel();
								//Changes made by Pratheek on 20-08-18[on second time when click on menu server call was getting call to load homepage ]-Start
								if( e12PnlGenWidget.getWidgetCount() > 0 )
								//Changes made by Pratheek on 20-08-18[on second time when click on menu server call was getting call to load homepage ]-End
								{
									if( e12PnlGenWidget.getWidget(0) instanceof HorizontalPanel )
									{
										horzPanel = (HorizontalPanel) e12PnlGenWidget.getWidget(0);
										if( horzPanel.getWidget(0) instanceof VerticalPanel )
										{
											newE12PnlGenWidget = (VerticalPanel) horzPanel.getWidget(0);
										}
									}
								}
								//Added By Suraj on 28-feb-2017 [To handle multiple click on Calendar Menu]Start
								//VerticalPanel vertPanel = new VerticalPanel();
								int calWdCount = e12PnlGenWidget.getWidgetCount();
								E12CommonUtils.printOnConsole("BaseE12 : 1419 calWdCount ["+calWdCount+"] current objType ["+objType+"] menuIdStr ["+menuIdStr+"]");
								//For multiple click handle
								if( calWdCount > 1 && ( objType.equals( "C" ) || objType.equals( "M" ) || objType.equals( "I" ) ) )
								{
									//Changed by Prasad on 03/05/18 [open existing selected menu's] START
									TextBox tbID = null;
									if( e12PnlGenWidget.getWidget( 0 ) instanceof TextBox )
									{
										tbID = ( TextBox ) e12PnlGenWidget.getWidget( 1 );
									}
									if( e12PnlGenWidget.getWidget( 1 ) instanceof TextBox )
									{
										E12CommonUtils.printOnConsole("BaseE12 : 1431 second");
										tbID = ( TextBox ) e12PnlGenWidget.getWidget( 1 );
									}
									E12CommonUtils.printOnConsole("1433 : menuId ["+menuIdStr+"] tabId ["+tbID.getText()+"]");
									if( menuIdStr.equalsIgnoreCase( tbID.getText() ) )
									{
										e12TransBrow.e12TabPanel.selectTab(i);
										isWidgetPresent = true;
										E12Global.getInstance().setMyCircleClick(false);
										//Added by Sagar M. on 02/11/18 [Removing and adding local js each time on menu click]Start
										E12CommonUtils.printOnConsole("BaseE12 inside remove js file objname ["+e12TransInfoObj.getObjName()+"]");
										E12CommonUtils.getInstance().removeJSFile(e12TransInfoObj.getObjName(), "js");
									    E12CommonUtils.printOnConsole("BaseE12 inside include jsfileName------"+e12TransInfoObj.getObjName());
										String jsFilePath = E12Global.getHostUrl() + "/ibase/webitm/js/"+e12TransInfoObj.getObjName()+".js";
										E12CommonUtils.getInstance().includeJSFile(jsFilePath);
										//Added by Sagar M. on 02/11/18 [Removing and adding local js each time on menu click]End
										break;
									}
									else
									{
										isWidgetPresent = false;
										//Added by shrutika on 20-07-17 For multiple click handle in delete report and confirm report
										E12Global.getInstance().setMyCircleClick(true);//shrutika
									}
									//Changed by Prasad on 03/05/18 [open existing selected menu's] END
								}
								//Added By Suraj on 28-feb-2017 [To handle multiple click on Calendar Menu]End
								else
								{
									if( newE12PnlGenWidget != null && newE12PnlGenWidget.getWidgetCount() > 1 )
									{
										if ( newE12PnlGenWidget.getWidgetCount() >= 2  )
										{
											TextBox tbID = ( TextBox ) newE12PnlGenWidget.getWidget( 1 );
											E12CommonUtils.printOnConsole("1418 : menuId ["+menuIdStr+"] tabId ["+tbID.getText()+"] isDcrOpen ["+isDcrOpen+"]");
											//Added by shrutika on 17-07-17 [Start] for Call Report Status menu issue
											if( menuIdStr.equalsIgnoreCase( tbID.getText() ) )
											{
												if("true".equalsIgnoreCase( isDcrOpen ) )
												{
													isWidgetPresent = false;
													isDcrOpen = "false";
//												e12TransBrow.e12TabPanel.remove(i);
													e12TransBrow.e12TabPanel.remove( tbID.getText(), i);
												}
												else
												{
													e12TransBrow.e12TabPanel.selectTab(i);
													isWidgetPresent = true;
													//Added by Prasad on 03/05/18 [open existing selected menu's]
													//Added by Sagar M. on 02/11/18 [Removing and adding local js each time on menu click]Start
													E12CommonUtils.printOnConsole("BaseE12 inside remove js file objname ["+e12TransInfoObj.getObjName()+"]");
													E12CommonUtils.getInstance().removeJSFile(e12TransInfoObj.getObjName(), "js");
												    E12CommonUtils.printOnConsole("BaseE12 inside include jsfileName------"+e12TransInfoObj.getObjName());
													String jsFilePath = E12Global.getHostUrl() + "/ibase/webitm/js/"+e12TransInfoObj.getObjName()+".js";
													E12CommonUtils.getInstance().includeJSFile(jsFilePath);
													//Added by Sagar M. on 02/11/18 [Removing and adding local js each time on menu click]End
													break;
												}
											}
											//Added by shrutika on 17-07-17 [End] for Call Report Status menu issue
											/*if( menuIdStr.equalsIgnoreCase( tbID.getText() ) )
											{
												e12TransBrow.e12TabPanel.selectTab(i);
												isWidgetPresent = true;
											}*/
										}
									}
								}
								//Changed by Sandeep S. on 23-02-17 End
							}
							E12CommonUtils.printOnConsole(" nilesh ****** isWidgetPresent ..1544"+isWidgetPresent);
							if( isWidgetPresent == false )
							{
								//Changed By Mahesh Patidar on 23-OCT-13 [to add Z objType for GWT process Window]
//							if( objType.equals( "W" ) )
								if( objType.equals( "W" ) || objType.equals( "Z" ) )
								{
									
									//Added by shrutika on 18-01-19 [Start] for getting first widget on click of close tab for remove user activities.
									E12CommonUtils.printOnConsole(" inside opentansaction....1803 ****** nil "+campId);
									TextBox tabIdTxtBx = new TextBox();
									tabIdTxtBx.setText(menuIdStr);
									tabIdTxtBx.setVisible( false );
									tabIdTxtBx.setHeight("0px");
									//Added by shrutika on 18-01-19 [End] for getting first widget on click of close tab for remove user activities.

									E12PopupContainer popContainer = new E12PopupContainer();
									//Added by Pooja S on 7-NOVEMBER-2019 [To set the popupContrainer]
									E12CommonUtils.getInstance().setPopUpContainer(popContainer);
									//E12SidePanelContainers e12SidePanelContainers = new E12SidePanelContainers(e12TransInfoObj, instanceIdStr, callerInterface, null);
									E12SidePanelContainers e12SidePanelContainers = new E12SidePanelContainers(e12TransInfoObj, instanceIdStr, callerInterface, true,"A",popContainer,null,campId, brandCode);
									VerticalPanel vPanel = (VerticalPanel) e12SidePanelContainers.getWidget();
									vPanel.setStyleName("tabContentPanel");
									popContainer.openWidget(vPanel);
									//e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, title);
									//changed by parikshit on 29/12/16 [to add side panel] end
									//e12TransBrow.e12TabPanel.selectTab( 1 );
								}
								else if( objType.equals("T") )
								{

									//Added by shrutika on 18-01-19 [Start] for getting first widget on click of close tab for remove user activities.
									E12CommonUtils.printOnConsole("inside opentansaction....1803");
									TextBox tabIdTxtBx = new TextBox();
									tabIdTxtBx.setText(menuIdStr);
									tabIdTxtBx.setVisible( false );
									tabIdTxtBx.setHeight("0px");
									//Added by shrutika on 18-01-19 [End] for getting first widget on click of close tab for remove user activities.
									//changed by parikshit on 29/12/16 [to add side panel] start
									/*E12HomePage e12HomePage = new E12HomePage();
									VerticalPanel vPanel =  e12HomePage.createE12HomePage( e12TransInfoObj, menuIdStr );*/
									E12SidePanelContainers e12SidePanelContainers = new E12SidePanelContainers(e12TransInfoObj, instanceIdStr, callerInterface, null);
									VerticalPanel vPanel =  e12SidePanelContainers.getWidget();

									//Added by shrutika on 18-01-19 [Start] for getting first widget on click of close tab for remove user activities.
									vPanel.add(tabIdTxtBx);
									vPanel.setStyleName("tabContentPanel");
									e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, e12SidePanelContainers.e12HomePage, title, "");
									//changed by parikshit on 29/12/16 [to add side panel] end
									e12TransBrow.e12TabPanel.selectTab(1);
								}
								//Added By UMAKANTA On 12/FEB/2015 [ For display report through Browser Interface ] Start
								else if( objType.equals("R") )
								{
									//Added by Pratheek on 06-03-18[to call Report in Browser]-Start
									//Added by Prasad on 02/11/17 [implementation of side panel for report] START
									E12SidePanelContainers e12SidePanelContainers = new E12SidePanelContainers(e12TransInfoObj, instanceIdStr, callerInterface, null);
									//E12Report e12Report = new E12Report( e12TransInfoObj );
									//Added by shrutika on 18-01-19 [Start] for getting first widget on click of close tab for remove user activities.
									TextBox tabIdTxtBx = new TextBox();
									tabIdTxtBx.setText(menuIdStr);
									tabIdTxtBx.setVisible( false );
									tabIdTxtBx.setHeight("0px");
									//Added by shrutika on 18-01-19 [End] for getting first widget on click of close tab for remove user activities.
									//VerticalPanel vTabPanel =  new VerticalPanel();
									VerticalPanel vTabPanel =  e12SidePanelContainers.getWidget();
									//vTabPanel.add( e12Report );
									//Added by Prasad on 02/11/17 [implementation of side panel for report] END
//								vTabPanel.add( tabIdTxtBx );
									//vTabPanel.setStylePrimaryName( "mainPage-Container" );
									E12CommonUtils.printOnConsole("Before Insert method in TabPanel 1666!!!!");
//								e12TransBrow.e12TabPanel.insert( vTabPanel, getTabWidget( vTabPanel, title ), 1);

									//Added by shrutika on 18-01-19 [Start] for getting first widget on click of close tab for remove user activities.
									vTabPanel.add(tabIdTxtBx);
									// added mahesh saggam on 10-OCT-19 [to add poppanel which slides in and out the menupanel on maximize]
									vTabPanel.setStyleName("reportTabContentPanel");
									e12TransBrow.e12TabPanel.insertTab( vTabPanel, getTabWidget( vTabPanel, title ), 1, title);
									e12TransBrow.e12TabPanel.selectTab(1);
									//Added by Pratheek on 06-03-18[to call Report in Browser]-End
								}//Added By UMAKANTA On 12/FEB/2015 [ For display report through Browser Interface ] End
								else if( objType.equals("G") )
								{
									VerticalPanel vPanel =  new E12TransPanelGenerator().createE12TransPanel( e12TransInfoObj );
									vPanel.setStyleName("tabContentPanel");
									e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, title);
									e12TransBrow.e12TabPanel.selectTab(1);
								}
								//Added by Pratheek on 25-05-18[to call the process screen same as wizard]-Start
								else if( objType.equals("P") )
								{
									if(instanceIdStr == null)
									{
										instanceIdStr = E12Constants.userID + generateRandomNo();;
									}
									//Added by shrutika on 18-01-19 [Start] for getting first widget on click of close tab for remove user activities.
									E12CommonUtils.printOnConsole("inside opentansaction....1803");
									TextBox tabIdTxtBx = new TextBox();
									tabIdTxtBx.setText(menuIdStr);
									tabIdTxtBx.setVisible( false );
									tabIdTxtBx.setHeight("0px");
									//Added by shrutika on 18-01-19 [End] for getting first widget on click of close tab for remove user activities.
//								VerticalPanel vPanel = ( VerticalPanel ) ( new E12PanelGenerator().createE12TransPanel( e12TransBrow, e12TransInfoObj, instanceIdStr ) );
									//e12TransBrow.e12TabPanel.insert( vPanel, title, 1 );
									E12SidePanelContainers e12SidePanelContainers = new E12SidePanelContainers(e12TransInfoObj, instanceIdStr, callerInterface, null);
									E12CommonUtils.printOnConsole("menuIdStr 1663!!!!!{"+menuIdStr+"}");
									VerticalPanel vPanel =  e12SidePanelContainers.getWidget();

									vPanel.setStylePrimaryName( "tabContentPanel" );
									//Added by shrutika on 18-01-19 [Start] for getting first widget on click of close tab for remove user activities.
									vPanel.add(tabIdTxtBx);
									e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, title);
									e12TransBrow.e12TabPanel.selectTab( 1 );
									if(E12Global.isGalaxy())
									{
										((Element) vPanel.getElement().getFirstChild().getChild(1)).setAttribute("style", "height: 0px;");
									}
								}
								//Added by Pratheek on 25-05-18[to call the process screen same as wizard]-End
								else if( objType.equals("C") )
								{
									if(instanceIdStr == null)
									{
										instanceIdStr = E12Constants.userID + generateRandomNo();;
									}
									E12PanelGenerator e12PanelGenerator = new E12PanelGenerator();
									VerticalPanel vPanel = ( VerticalPanel ) ( e12PanelGenerator.createE12TransPanel( e12TransInfoObj, instanceIdStr ) );
									vPanel.setStylePrimaryName( "tabContentPanel" );
									//Changed By Suraj on 19-01-2017 [To set objName and objType on tab selection]
									//e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, title);
									e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, e12PanelGenerator, title, menuIdStr.replace(".", "_"));
									e12TransBrow.e12TabPanel.selectTab(1);
									((Element) vPanel.getElement().getFirstChild().getChild(1)).setAttribute("style", "height: 0px;");
								}
								//Added by Savita Yadav on 18-05-2015 [For Bulk delete attachment]-Start
								else if( objType.equals("D") )
								{
									VerticalPanel vPanel =  new E12BulkDelete().createSearchPanel(e12TransInfoObj);
									vPanel.setStyleName("tabContentPanel");
									e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, title);
									e12TransBrow.e12TabPanel.selectTab(1);
								}
								//Added by Savita Yadav on 18-05-2015 [For Bulk delete attachment]-End
								//Added by Chetan Mahajan on 08-09-2015 [For Workflow pending transaction Req id : W15FSUN005] - Start
								else if( objType.equals("H") )
								{
									WFPRCDataView e12workflowstatus = new WFPRCDataView( e12TransInfoObj );
									VerticalPanel vTabPanel = new VerticalPanel();
									vTabPanel.add(e12workflowstatus);
									vTabPanel.setStylePrimaryName( "mainPage-Container-panel" );
									e12TransBrow.e12TabPanel.insert( vTabPanel, getTabWidget( vTabPanel, title ), 1);
									e12TransBrow.e12TabPanel.selectTab(1);
								}
								//Added by Chetan Mahajan on 08-09-2015 [For Workflow pending transaction Req id : W15FSUN005] - End
								//Added By Prasad on 15/06/15 [to add E (for Document Upload with Transaction)] START
								else if( objType.equals("E") )
								{
									VerticalPanel vPanel;
									if ( e12TransInfoObj.getObjName().indexOf("/") != -1 )
									{
										vPanel = ( VerticalPanel ) ( new E12PanelGenerator().createE12TransPanel( e12TransInfoObj, instanceIdStr ) );
										//Changes by Prajyot - 19/07/2019 [CSS class name change as per other tabs created]
										//vPanel.setStylePrimaryName( "mainLayoutStyle" );
										vPanel.setStylePrimaryName( "tabContentPanel" );
										e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, title);
										if(E12Global.isGalaxy())
										{
											((Element) vPanel.getElement().getFirstChild().getChild(1)).setAttribute("style", "height: 0px;");
										}
									}
									else
									{
										E12HomePage e12HomePage = new E12HomePage();
										vPanel =  e12HomePage.createE12HomePage( e12TransInfoObj, menuIdStr );
										vPanel.setStyleName("tabContentPanel");
										e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, e12HomePage, title, "");
									}
									e12TransBrow.e12TabPanel.selectTab(1);
								}
								//Added By Prasad on 15/06/15 [to add E (for Document Upload with Transaction)] END
								//Added By Prashant Chavan  on 26-Aug-15 [ For Survey] START
								else if( objType.equals("S") )
								{
									E12Survey e12Survey = new E12Survey( e12TransInfoObj );
									VerticalPanel vTabPanel =  new VerticalPanel();
									vTabPanel.add(e12Survey);
									vTabPanel.setStylePrimaryName( "mainPage-Container" );
									e12TransBrow.e12TabPanel.insert( vTabPanel, getTabWidget( vTabPanel, title ), 1);
									e12TransBrow.e12TabPanel.selectTab(1);
								}
								//Added By Prashant Chavan  on 26-Aug-15 [ For Survey] END
								//Added By Prajyot Rumde on 19-JUN-18 [ For Dashboard Load From Menu for objType A] START
								else if( objType.equals("A") )
								{
									//Changed by Pravin K [To show message notification panel] on 27-NOV-19 START 
									if("message_comp".equalsIgnoreCase( E12Constants.objName) ) 
									{
										
										E12CommonUtils.printOnConsole("1: Notification component ");
										VerticalPanel notificationScrPanel = new VerticalPanel();
										
										NotificationPanel notificationPanel = new NotificationPanel();
										notificationScrPanel.add(notificationPanel.getAddUI());
										notificationScrPanel.setStyleName("notificatinScrollPanel");
										
										notificationScrPanel.getElement().setAttribute("data-tab-id", menuIdStr);
										e12TransBrow.e12TabPanel.insert(notificationScrPanel, getTabWidget( notificationScrPanel, title ), 1);
										e12TransBrow.e12TabPanel.selectTab(1);
									}
									else
									{
										
										E12ANGReport angReport = new E12ANGReport(e12TransInfoObj);
										VerticalPanel vTabPanel =  new VerticalPanel();
										E12CommonUtils.printOnConsole("objType and angReport  !!!!!{"+objType+"}["+ angReport + "]");
										vTabPanel.add(angReport);
										TextBox tbID = new TextBox();
										tbID.setText( e12TransInfoObj.getId() );
										tbID.setVisible( false );
										vTabPanel.add( tbID );
										vTabPanel.setStylePrimaryName( "mainPage-Container" );
										e12TransBrow.e12TabPanel.insert( vTabPanel, getTabWidget( vTabPanel, title ), 1);
										e12TransBrow.e12TabPanel.selectTab(1);
									}
									//Changed by Pravin K [To show message notification panel] on 27-NOV-19 END
								}
								//Added By Prajyot Rumde on 19-JUN-18 [ For Dashboard Load From Menu for objType A]  END
								//Added By Shrutika N. on 16-12-2020 added new obj_type j to open angular component for incentive process to show a processid according to win_name - start
								else if( objType.equals("J") ) 
								{
									E12CommonUtils.printOnConsole("inside objType j.............2142");
									
									VerticalPanel vTabPanel =  new VerticalPanel();
									final String targetId = "generalized_process";
									
									String objName = e12TransInfoObj.getObjName();
									E12CommonUtils.printOnConsole("inside objType j.............2155"+objName);
									
									final JSONObject configData = new JSONObject();
									configData.put("componentName", new JSONString(targetId));
									configData.put("targetId", new JSONString(targetId));
									configData.put("OBJ_NAME", new JSONString(objName));
									
									E12CommonUtils.printOnConsole("inside objType j.............2162"+configData.toString());
									
									E12AngularComponent e12AngularComponent = new E12AngularComponent( targetId , configData.toString() );
									vTabPanel.add(e12AngularComponent);
									
									TextBox tbID = new TextBox();
									tbID.setText( e12TransInfoObj.getId() );
									tbID.setVisible( false );
									vTabPanel.add( tbID );
									vTabPanel.setStylePrimaryName( "mainPage-Container" );
									e12TransBrow.e12TabPanel.insert( vTabPanel, getTabWidget( vTabPanel, title ), 1);
									e12TransBrow.e12TabPanel.selectTab(1);
								}
								//Added By Shrutika N. on 16-12-2020 added new obj_type j to open angular component for incentive process to show a processid according to win_name - end
								//Added By nikhil on 23-02-2022 added new obj_type v to open angular component for shared visual to show a processid according to win_name [Start]
								else if( objType.equals("V") ) 
								{
									E12CommonUtils.printOnConsole("inside objType v.............4189");
									
									VerticalPanel vTabPanel =  new VerticalPanel();
									final String targetId = "dash_def";
									
									String objName = e12TransInfoObj.getObjName();
									E12CommonUtils.printOnConsole("inside objType v.............4195"+objName);
									
									final JSONObject configData = new JSONObject();
									configData.put("componentName", new JSONString(targetId));
									configData.put("targetId", new JSONString(targetId));
									configData.put("OBJ_NAME", new JSONString(objName));
									
									E12CommonUtils.printOnConsole("inside objType v.............4202"+configData.toString());
									
									E12AngularComponent e12AngularComponent = new E12AngularComponent( targetId , configData.toString() );
									vTabPanel.add(e12AngularComponent);
									
									TextBox tbID = new TextBox();
									tbID.setText( e12TransInfoObj.getId() );
									tbID.setVisible( false );
									vTabPanel.add( tbID );
									vTabPanel.setStylePrimaryName( "mainPage-Container" );
									e12TransBrow.e12TabPanel.insert( vTabPanel, getTabWidget( vTabPanel, title ), 1);
									e12TransBrow.e12TabPanel.selectTab(1);
								}
								//Added By nikhil on 23-02-2022 added new obj_type v to open angular component for shared visual to show a processid according to win_name [End]
								else
								{
									if(instanceIdStr == null)
									{
										instanceIdStr = E12Constants.userID + generateRandomNo();;
									}
									VerticalPanel vPanel = ( VerticalPanel ) ( new E12PanelGenerator().createE12TransPanel( e12TransInfoObj, instanceIdStr ) );
									//e12TransBrow.e12TabPanel.insert( vPanel, title, 1 );
									//Changes by Prajyot - 19/07/2019 [CSS class name change as per other tabs created]
									//vPanel.setStylePrimaryName( "mainLayoutStyle" );
									vPanel.setStylePrimaryName( "tabContentPanel" );
									e12TransBrow.e12TabPanel.insertTab( vPanel, getTabWidget( vPanel, title ), 1, title);
									e12TransBrow.e12TabPanel.selectTab( 1 );
									if(E12Global.isGalaxy())
									{
										((Element) vPanel.getElement().getFirstChild().getChild(1)).setAttribute("style", "height: 0px;");
									}
								}
							}
						}
						//Changes By Prajyot on 24-08-2011 [ To restrict user from opening more than 12 Tabs ] Ends
					}
					else
					{
						Window.alert( invalidObj );
					}
				}
				else
				{
					//Added by sunny soni for showing restricted menu title message on 09-Feb-22 [Start]
					String msg = "";
					if (E12CommonUtils.checkNull(e12TransInfoObj.getTitle()).length() > 0)
					{
						//msg = e12TransInfoObj.getTitle() + " is not accessible for current Devices";
						msg = e12TransInfoObj.getTitle() + " is " + constants.getRestrictPartMessage();
					}
					else 
					{
						msg = e12TransInfoObj.getRestrictMsg();
					}
					Window.alert( msg );
					//Added by sunny soni for showing restricted menu title message on 09-Feb-22 [End]
					//Window.alert( e12TransInfoObj.getRestrictMsg() );
				}
				////Changed By Suraj on 14-12-2016 [For menu restriction]End
			}
		}
		catch (Exception e)
		{
			E12CommonUtils.printOnConsole("Exception in openTransaction ["+e.getMessage()+"]");
			e.printStackTrace();
		}
	}
	
	//Added By Nilesh from the anguler we called this method to pass the parameter End :: 08-02-2021
	
	//Added by sunny soni for loading css with enterprise type on 25-Nov-21[Start]
	public static void injectCssFile(final String cssFileName) 
	{
		try 
		{			
			LinkElement link = com.google.gwt.dom.client.Document.get().createLinkElement();
			link.setRel("stylesheet");
			link.setHref(cssFileName + ".css");
			nativeAttachToHead(link);
		}
		catch (Exception e) {
			E12CommonUtils.printOnConsole("Exception in injectCssFile::"+e);
		}		
	}
	
	private static native void nativeAttachToHead(JavaScriptObject scriptElement) /*-{
		try 
		{
			$doc.getElementsByTagName("head")[0].appendChild(scriptElement);
		}
		catch (ex) {
			console.log('Exception in nativeAttachToHead:::'+ex);
		}    	
	}-*/;
	//Added by sunny soni for loading css with enterprise type on 25-Nov-21[End]
}
